/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.cvfv;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.cvfv.TypeAndValueBirthmarkElement;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConstantValueOfFieldVariableBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    private Birthmark birthmark;
    private Map<String, TypeAndValueBirthmarkElement> elements = new LinkedHashMap<String, TypeAndValueBirthmarkElement>();
    private String className;

    public ConstantValueOfFieldVariableBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, context);
        this.birthmark = birthmark;
    }

    public void visitEnd() {
        for (String key : this.elements.keySet()) {
            this.birthmark.addElement(this.elements.get(key));
        }
        super.visitEnd();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor visitor = super.visitField(access, name, desc, signature, value);
        TypeAndValueBirthmarkElement e = this.elements.get(name);
        if (e == null) {
            e = new TypeAndValueBirthmarkElement(name, desc, value);
        } else if (value != null) {
            e.setValue(value);
        }
        this.elements.put(name, e);
        return visitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Object visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>") || name.equals("<clinit>")) {
            visitor = new MethodAdapter((MethodVisitor)visitor){
                private Object constant;
                {
                    this.constant = null;
                }

                public void visitIntInsn(int opcode, int operand) {
                    if (opcode == 16 || opcode == 17) {
                        this.constant = new Integer(operand);
                    }
                    super.visitIntInsn(opcode, operand);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    Type type = Type.getReturnType((String)desc);
                    if (!type.equals((Object)Type.VOID_TYPE)) {
                        this.constant = null;
                    }
                    super.visitMethodInsn(opcode, owner, name, desc);
                }

                public void visitInsn(int opcode) {
                    if (opcode == 2) {
                        this.constant = new Integer(-1);
                    } else if (opcode == 3) {
                        this.constant = new Integer(0);
                    } else if (opcode == 4) {
                        this.constant = new Integer(1);
                    } else if (opcode == 5) {
                        this.constant = new Integer(2);
                    } else if (opcode == 6) {
                        this.constant = new Integer(3);
                    } else if (opcode == 7) {
                        this.constant = new Integer(4);
                    } else if (opcode == 8) {
                        this.constant = new Integer(5);
                    } else if (opcode == 9) {
                        this.constant = new Long(0L);
                    } else if (opcode == 10) {
                        this.constant = new Long(1L);
                    } else if (opcode == 14) {
                        this.constant = new Double(0.0);
                    } else if (opcode == 15) {
                        this.constant = new Double(1.0);
                    } else if (opcode == 11) {
                        this.constant = new Float(0.0f);
                    } else if (opcode == 12) {
                        this.constant = new Float(1.0f);
                    } else if (opcode == 13) {
                        this.constant = new Float(2.0f);
                    }
                    super.visitInsn(opcode);
                }

                public void visitLdcInsn(Object object) {
                    this.constant = object;
                    super.visitLdcInsn(object);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    if (ConstantValueOfFieldVariableBirthmarkExtractVisitor.this.className.equals(owner) && opcode == 181) {
                        TypeAndValueBirthmarkElement e = (TypeAndValueBirthmarkElement)ConstantValueOfFieldVariableBirthmarkExtractVisitor.this.elements.get(name);
                        if (e == null) {
                            e = new TypeAndValueBirthmarkElement(name, desc, this.constant);
                        }
                        if (e.getValue() == null && this.constant != null) {
                            if (!ConstantValueOfFieldVariableBirthmarkExtractVisitor.this.checkCast(desc, this.constant)) {
                                this.constant = null;
                            }
                            e.setValue(this.constant);
                        }
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            };
        }
        return visitor;
    }

    private boolean checkCast(String desc, Object constant) {
        if (constant instanceof Integer) {
            return desc.equals("Ljava/lang/Integer;") || desc.equals("I") || desc.equals("S") || desc.equals("Z") || desc.equals("C") || desc.equals("B");
        }
        if (constant instanceof Float) {
            return desc.equals("Ljava/lang/Float;") || desc.equals("F");
        }
        if (constant instanceof Double) {
            return desc.equals("Ljava/lang/Double;") || desc.equals("D");
        }
        if (constant instanceof Long) {
            return desc.equals("Ljava/lang/Long;") || desc.equals("J");
        }
        if (constant instanceof String) {
            return desc.equals("Ljava/lang/String;");
        }
        return false;
    }
}

