package jp.naist.se.stigmata.birthmarks;

/*
 * $Id: LocalizedDescriptionManager.java 22 2007-01-29 15:12:20Z tama3 $
 */

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author Haruaki TAMADA
 * @version $Revision: 22 $ $Date: 2007-01-30 00:12:20 +0900 (Tue, 30 Jan 2007) $
 */
public class LocalizedDescriptionManager{
    private Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>();

    /**
     * only one instance of singleton pattern.
     */
    private static LocalizedDescriptionManager manager = new LocalizedDescriptionManager();

    private LocalizedDescriptionManager(){
    }

    public String getDisplayType(Locale locale, String birthmarkType){
        try{
            return getBundle(locale).getString("birthmark." + birthmarkType + ".display.type");
        } catch(MissingResourceException e){
            return null;
        }
    }

    public String getDescription(Locale locale, String birthmarkType){
        try{
            return getBundle(locale).getString("birthmark." + birthmarkType + ".description");
        } catch(MissingResourceException e){
            return null;
        }
    }

    private ResourceBundle getBundle(Locale locale){
        ResourceBundle bundle = resources.get(locale);
        if(bundle == null){
            bundle = ResourceBundle.getBundle("resources.description", locale);
            resources.put(locale, bundle);
        }
        return bundle;
    }

    public static LocalizedDescriptionManager getInstance(){
        return manager;
    }
}
