package jp.naist.se.stigmata.format;

/*
 * $Id: FormatManager.java 20 2007-01-17 02:06:01Z tama3 $
 */

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.format.csv.CsvResultFormatService;
import jp.naist.se.stigmata.spi.ResultFormatSpi;

/**
 *
 * @author Haruaki TAMADA
 * @version $Revision: 20 $ $Date: 2007-01-17 11:06:01 +0900 (Wed, 17 Jan 2007) $
 */
public class FormatManager{
    private static final FormatManager manager = new FormatManager();

    private Map<String, ResultFormatSpi> formats = new HashMap<String, ResultFormatSpi>();

    private FormatManager(){
        for(Iterator<ResultFormatSpi> i = ServiceRegistry.lookupProviders(ResultFormatSpi.class); i.hasNext(); ){
            ResultFormatSpi spi = i.next();
            formats.put(spi.getFormat(), spi);
        }
    }

    public static ResultFormatSpi getDefaultFormatService(){
        return new CsvResultFormatService();
    }

    public static FormatManager getInstance(){
        return manager;
    }

    public ResultFormatSpi getService(String format){
        return formats.get(format);
    }
}
