/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.utils.WellknownClassManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkContext {
    private static BirthmarkContext DEFAULT_CONTEXT = new BirthmarkContext(true);
    private BirthmarkContext parent;
    private ClasspathContext bytecodeContext;
    private WellknownClassManager manager;
    private Map<String, BirthmarkSpi> services = new HashMap<String, BirthmarkSpi>();
    private Map<String, String> properties = new HashMap<String, String>();

    private BirthmarkContext(boolean flag) {
        this.manager = new WellknownClassManager();
        this.bytecodeContext = ClasspathContext.getDefaultContext();
    }

    public BirthmarkContext() {
        this(BirthmarkContext.getDefaultContext());
    }

    public BirthmarkContext(BirthmarkContext parent) {
        this.parent = parent;
        this.manager = new WellknownClassManager(parent.getWellknownClassManager());
        this.bytecodeContext = new ClasspathContext(parent.getBytecodeContext());
    }

    public static final BirthmarkContext getDefaultContext() {
        return DEFAULT_CONTEXT;
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value == null && this.parent != null) {
            value = this.parent.getProperty(key);
        }
        return value;
    }

    public ClasspathContext getBytecodeContext() {
        return this.bytecodeContext;
    }

    public synchronized void addService(BirthmarkSpi service) {
        if (this.parent == null || this.parent.getService(service.getType()) == null) {
            this.services.put(service.getType(), service);
        }
    }

    public void removeService(String type) {
        this.services.remove(type);
    }

    public BirthmarkSpi getService(String type) {
        BirthmarkSpi service = this.services.get(type);
        if (service == null && this.parent != null) {
            service = this.parent.getService(type);
        }
        return service;
    }

    public synchronized BirthmarkSpi[] getServices() {
        List<BirthmarkSpi> list = this.getServiceList();
        return list.toArray(new BirthmarkSpi[list.size()]);
    }

    public synchronized BirthmarkSpi[] findServices() {
        List<BirthmarkSpi> list = this.getServiceList();
        Iterator<BirthmarkSpi> i = ServiceRegistry.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi spi = i.next();
            if (this.getService(spi.getType()) != null) continue;
            list.add(spi);
        }
        return list.toArray(new BirthmarkSpi[list.size()]);
    }

    public WellknownClassManager getWellknownClassManager() {
        return this.manager;
    }

    private List<BirthmarkSpi> getServiceList() {
        ArrayList<BirthmarkSpi> list = new ArrayList<BirthmarkSpi>();
        if (this.parent != null) {
            for (BirthmarkSpi spi : this.parent.getServices()) {
                list.add(spi);
            }
        }
        for (String key : this.services.keySet()) {
            list.add(this.services.get(key));
        }
        return list;
    }
}

