/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private int[] mapping = new int[40];
    protected final int firstLocal;
    private int nextLocal;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        super(mv);
        Type[] args = Type.getArgumentTypes(desc);
        this.nextLocal = (8 & access) != 0 ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            this.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int opcode, int var) {
        int size;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, size));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, 1), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.nextLocal);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        int size = "J".equals(desc) || "D".equals(desc) ? 2 : 1;
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.remap(index, size));
    }

    protected int newLocal(int size) {
        int var = this.nextLocal;
        this.nextLocal += size;
        return var;
    }

    private int remap(int var, int size) {
        int value;
        if (var < this.firstLocal) {
            return var;
        }
        int key = 2 * var + size - 1;
        int length = this.mapping.length;
        if (key >= length) {
            int[] newMapping = new int[Math.max(2 * length, key + 1)];
            System.arraycopy(this.mapping, 0, newMapping, 0, length);
            this.mapping = newMapping;
        }
        if ((value = this.mapping[key]) == 0) {
            this.mapping[key] = value = this.nextLocal + 1;
            this.nextLocal += size;
        }
        return value - 1;
    }
}

