/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.utils;

public class WellknownClassSection {
    public static final int PREFIX_TYPE = 1;
    public static final int SUFFIX_TYPE = 2;
    public static final int MATCH_TYPE = 4;
    public static final int FULLY_TYPE = 16;
    public static final int PACKAGE_TYPE = 32;
    public static final int CLASS_NAME_TYPE = 64;
    public static final int EXCLUDE_TYPE = 128;
    private int type;
    private String name;

    public WellknownClassSection(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public boolean isExcludeType() {
        return this.getMatchPartType() == 128;
    }

    public boolean isFullyType() {
        return this.getMatchPartType() == 16;
    }

    public boolean isPackageType() {
        return this.getMatchPartType() == 32;
    }

    public boolean isClassNameType() {
        return this.getMatchPartType() == 64;
    }

    public int getMatchPartType() {
        return this.getType() & 0xF0;
    }

    public int getMatchType() {
        return this.getType() & 0xF;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        switch (this.getMatchType()) {
            case 1: {
                return "<prefix>" + this.getName() + "</prefix>";
            }
            case 2: {
                return "<suffix>" + this.getName() + "</suffix>";
            }
            case 4: {
                return "<match>" + this.getName() + "</match>";
            }
        }
        return null;
    }
}

