/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.utils.WellknownClassManager;
import jp.naist.se.stigmata.utils.WellknownClassSection;

public class WellknownClassesSettingsPane
extends JPanel {
    private static final long serialVersionUID = 329734546345634532L;
    private JTable sectionTable = null;
    private DefaultTableModel model;
    private WellknownClassManager manager;
    private JComboBox checkPartType;
    private JComboBox matchType;
    private String matchTypeColumnIdentifier;
    private String checkPartColumnIdentifier;
    private String patternColumnIdentifier;

    public WellknownClassesSettingsPane(WellknownClassManager manager) {
        super(new BorderLayout());
        this.manager = manager;
        this.initialize();
        this.initializeData();
    }

    public synchronized void setWellknownClasses(WellknownClassManager manager) {
        manager.clear();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            int partType = this.getPartType(this.model.getValueAt(i, 0));
            int match = this.getMatchType(this.model.getValueAt(i, 1));
            String value = (String)this.model.getValueAt(i, 2);
            WellknownClassSection sect = new WellknownClassSection(value, partType | match);
            manager.add(sect);
        }
    }

    public synchronized WellknownClassManager createWellknownClassManager() {
        WellknownClassManager manager = new WellknownClassManager();
        this.setWellknownClasses(manager);
        return manager;
    }

    public void reset() {
        for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        this.initializeData();
    }

    private synchronized boolean isWellknownClass(String className) {
        WellknownClassManager manager = this.createWellknownClassManager();
        return manager.isWellKnownClass(className);
    }

    private int getPartType(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object.equals(Messages.getString("fully.label"))) {
            return 16;
        }
        if (object.equals(Messages.getString("package.label"))) {
            return 32;
        }
        if (object.equals(Messages.getString("classname.label"))) {
            return 64;
        }
        if (object.equals(Messages.getString("exclude.label"))) {
            return 128;
        }
        return 16;
    }

    private int getMatchType(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object.equals(Messages.getString("prefix.label"))) {
            return 1;
        }
        if (object.equals(Messages.getString("suffix.label"))) {
            return 2;
        }
        if (object.equals(Messages.getString("exactmatch.label"))) {
            return 4;
        }
        return 1;
    }

    public void addSection() {
        JPanel inputPanel = new JPanel(new GridLayout(3, 2));
        JTextField text = new JTextField();
        inputPanel.setOpaque(true);
        inputPanel.add(new JLabel(this.matchTypeColumnIdentifier));
        inputPanel.add(this.matchType);
        inputPanel.add(new JLabel(this.checkPartColumnIdentifier));
        inputPanel.add(this.checkPartType);
        inputPanel.add(new JLabel(this.patternColumnIdentifier));
        inputPanel.add(text);
        int value = JOptionPane.showConfirmDialog(this, inputPanel, Messages.getString("addwellknown.dialog.title"), 2);
        if (value == 0) {
            int part = this.getPartType(this.checkPartType.getSelectedItem());
            int match = this.getMatchType(this.matchType.getSelectedItem());
            String pattern = text.getText();
            this.model.addRow(new Object[]{new Integer(part), new Integer(match), pattern});
        }
        this.adjustColumnPreferredWidths(this.sectionTable);
    }

    private void initializeData() {
        WellknownClassSection[] sections;
        for (WellknownClassSection section : sections = this.manager.getSections()) {
            this.model.addRow(new Object[]{new Integer(section.getMatchPartType()), new Integer(section.getMatchType()), section.getName()});
        }
        this.adjustColumnPreferredWidths(this.sectionTable);
    }

    private void adjustColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxWidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component component = renderer.getTableCellRendererComponent(table, value, false, false, row, col);
                maxWidth = (int)Math.max(component.getPreferredSize().getWidth(), (double)maxWidth);
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxWidth);
        }
    }

    private void initialize() {
        JPanel center = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.getSectionTable());
        center.add((Component)scroll, "Center");
        center.add((Component)this.createSouthPane(), "South");
        center.setBorder(new TitledBorder(Messages.getString("rules.border")));
        this.add((Component)center, "Center");
        this.add((Component)this.getCheckPanel(), "South");
    }

    private JComponent getCheckPanel() {
        final JTextField text = new JTextField();
        final JButton checkButton = Utility.createButton("checkwellknown");
        final JLabel label = new JLabel(Utility.getIcon("wellknownclasschecker.default.icon"));
        checkButton.setEnabled(false);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String t = text.getText().trim();
                if (t.length() > 0) {
                    if (WellknownClassesSettingsPane.this.isWellknownClass(t)) {
                        label.setIcon(Utility.getIcon("wellknownclasschecker.wellknown.icon"));
                        label.setToolTipText(Messages.getString("wellknownclasschecker.wellknown.tooltip"));
                    } else {
                        label.setIcon(Utility.getIcon("wellknownclasschecker.notwellknown.icon"));
                        label.setToolTipText(Messages.getString("wellknownclasschecker.notwellknown.tooltip"));
                    }
                }
            }
        };
        checkButton.addActionListener(listener);
        text.addActionListener(listener);
        text.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                checkButton.setEnabled(text.getText().trim().length() > 0);
            }

            public void insertUpdate(DocumentEvent arg0) {
                checkButton.setEnabled(text.getText().trim().length() > 0);
            }

            public void removeUpdate(DocumentEvent arg0) {
                checkButton.setEnabled(text.getText().trim().length() > 0);
            }
        });
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(text);
        south.add(Box.createHorizontalGlue());
        south.add(checkButton);
        south.add(Box.createHorizontalGlue());
        south.add(label);
        south.add(Box.createHorizontalGlue());
        south.setBorder(new TitledBorder(Messages.getString("wellknownclasschecker.border")));
        return south;
    }

    private JComponent createSouthPane() {
        Box southPanel = Box.createHorizontalBox();
        JButton addButton = Utility.createButton("addwellknown");
        final JButton removeButton = Utility.createButton("removewellknown");
        removeButton.setEnabled(false);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(addButton);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(removeButton);
        southPanel.add(Box.createHorizontalGlue());
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WellknownClassesSettingsPane.this.addSection();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = WellknownClassesSettingsPane.this.sectionTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    WellknownClassesSettingsPane.this.model.removeRow(rows[i]);
                }
                WellknownClassesSettingsPane.this.adjustColumnPreferredWidths(WellknownClassesSettingsPane.this.sectionTable);
            }
        });
        this.sectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                removeButton.setEnabled(WellknownClassesSettingsPane.this.sectionTable.getSelectedRowCount() > 0);
            }
        });
        return southPanel;
    }

    private JTable getSectionTable() {
        if (this.sectionTable == null) {
            this.model = new DefaultTableModel(0, 3);
            this.matchTypeColumnIdentifier = Messages.getString("matchtype.table.column");
            this.checkPartColumnIdentifier = Messages.getString("checkpart.table.column");
            this.patternColumnIdentifier = Messages.getString("pattern.table.column");
            this.model.setColumnIdentifiers(new Object[]{this.checkPartColumnIdentifier, this.matchTypeColumnIdentifier, this.patternColumnIdentifier});
            this.sectionTable = new JTable(this.model);
            this.checkPartType = new JComboBox();
            final String[] checkPartItems = Messages.getStringArray("checkpart.items");
            for (int i = 0; i < checkPartItems.length; ++i) {
                this.checkPartType.addItem(checkPartItems[i]);
            }
            TableColumn column1 = this.sectionTable.getColumn(this.checkPartColumnIdentifier);
            column1.setCellEditor(new DefaultCellEditor(this.checkPartType));
            column1.setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 923743563L;

                public void setValue(Object value) {
                    if (value instanceof Integer) {
                        int type = (Integer)value;
                        if (type == 16) {
                            this.setText(checkPartItems[0]);
                        } else if (type == 32) {
                            this.setText(checkPartItems[1]);
                        } else if (type == 64) {
                            this.setText(checkPartItems[2]);
                        } else if (type == 128) {
                            this.setText(checkPartItems[3]);
                        } else {
                            this.setText(value.toString());
                        }
                    } else {
                        this.setText(value.toString());
                    }
                }
            });
            this.matchType = new JComboBox();
            final String[] matchTypeStrings = Messages.getStringArray("matchtype.items");
            for (int i = 0; i < matchTypeStrings.length; ++i) {
                this.matchType.addItem(matchTypeStrings[i]);
            }
            TableColumn column2 = this.sectionTable.getColumn(this.matchTypeColumnIdentifier);
            column2.setCellEditor(new DefaultCellEditor(this.matchType));
            column2.setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 972356346L;

                public void setValue(Object value) {
                    if (value instanceof Integer) {
                        int type = (Integer)value;
                        if (type == 1) {
                            this.setText(matchTypeStrings[0]);
                        } else if (type == 2) {
                            this.setText(matchTypeStrings[1]);
                        } else if (type == 4) {
                            this.setText(matchTypeStrings[2]);
                        } else {
                            this.setText(value.toString());
                        }
                    } else {
                        this.setText(value.toString());
                    }
                }
            });
        }
        return this.sectionTable;
    }
}

