/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.stemmer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.trialpc.sticktools.stemmer.AbstractStemmer;
import net.trialpc.sticktools.stemmer.Stemmer;

public final class KrovetzStemmer
extends AbstractStemmer {
    private static final String EXCEPTION_WORD_FILE = "exception_words.txt.dat";
    private static final String DIRECT_CONFRATION_FILE = "direct_conflations.txt";
    private static final String DICT_SUPPLEMENT_FILE = "dict_supplement.txt";
    private static final String HEAD_WORD_FILE = "head_word_list.txt.dat";
    private static final String COUNTRY_NATIONALITY_FILE = "country_nationality.txt";
    private static final String PROPER_NOUN_FILE = "proper_nouns.txt.dat";
    private static final String DATA_DIR = "net/trialpc/langmodel/stemdata/";
    private static final String OPTIMIZED_FILE_EXT = ".dat";
    private static Map<String, String> nationality;
    private static Set<String> supplement;
    private static Map<String, String> conflation;
    private static Set<String> exceptionWord;
    private static Set<String> headWord;
    private static Set<String> properNoun;
    private static Map<String, String> dictionary;
    private static List<StemmingAction> actions;
    private static final int MIX_WORD_LENGTH = 2;
    private static final int MAX_WORD_LENGTH = 25;
    private static final Stemmer instance;

    static {
        instance = new KrovetzStemmer();
    }

    public static Stemmer getInstance() {
        return instance;
    }

    private KrovetzStemmer() {
        conflation = KrovetzStemmer.loadAsMap("net/trialpc/langmodel/stemdata/direct_conflations.txt");
        exceptionWord = KrovetzStemmer.loadAsSet("net/trialpc/langmodel/stemdata/exception_words.txt.dat");
        headWord = KrovetzStemmer.loadAsSet("net/trialpc/langmodel/stemdata/head_word_list.txt.dat");
        nationality = KrovetzStemmer.loadAsMap("net/trialpc/langmodel/stemdata/country_nationality.txt");
        properNoun = KrovetzStemmer.loadAsSet("net/trialpc/langmodel/stemdata/proper_nouns.txt.dat");
        supplement = KrovetzStemmer.loadAsSet("net/trialpc/langmodel/stemdata/dict_supplement.txt");
        dictionary = new HashMap<String, String>();
        dictionary.putAll(conflation);
        dictionary.putAll(KrovetzStemmer.translateSetToMap(exceptionWord));
        dictionary.putAll(KrovetzStemmer.translateSetToMap(headWord));
        dictionary.putAll(nationality);
        dictionary.putAll(KrovetzStemmer.translateSetToMap(properNoun));
        dictionary.putAll(KrovetzStemmer.translateSetToMap(supplement));
        actions = new ArrayList<StemmingAction>();
        actions.add(new Plural());
        actions.add(new PastTense());
        actions.add(new Aspect());
        actions.add(new ItyEndings());
        actions.add(new NessEndings());
        actions.add(new IonEndings());
        actions.add(new ErOfOrEndings());
        actions.add(new LyEndings());
        actions.add(new AlEndings());
        actions.add(new IveEndings());
        actions.add(new IzeEndings());
        actions.add(new MentEndings());
        actions.add(new BleEndings());
        actions.add(new IsmEndings());
        actions.add(new IcEndings());
        actions.add(new NcyEndings());
        actions.add(new NceEndings());
    }

    private static Map<String, String> translateSetToMap(Set<String> set) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : set) {
            map.put(s, s);
        }
        return map;
    }

    @Override
    public String interpret(String term) {
        boolean stemIt = true;
        int length = term.length();
        if (length <= 2 || length >= 25) {
            stemIt = false;
        } else {
            int i = 0;
            while (i < length) {
                if (!Character.isLetter(term.charAt(i))) {
                    stemIt = false;
                    break;
                }
                ++i;
            }
        }
        if (!stemIt) {
            return term.toLowerCase();
        }
        StemmedString word = new StemmedString(term);
        String dep = KrovetzStemmer.getdep(word);
        if (dep != null) {
            return dep;
        }
        for (StemmingAction action : actions) {
            word = action.tryStem(word);
            dep = KrovetzStemmer.getdep(word);
            if (dep == null) continue;
            return dep;
        }
        return word.getString();
    }

    private static boolean containsInDictionary(StemmedString word) {
        return KrovetzStemmer.getdep(word) != null;
    }

    private static boolean isExceptionalWord(String word) {
        return exceptionWord.contains(word);
    }

    private static String getdep(StemmedString word) {
        return dictionary.get(word.getString());
    }

    private static Map<String, String> loadAsMap(String path) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(KrovetzStemmer.class.getClassLoader().getResourceAsStream(path)));
            String s = null;
            while ((s = reader.readLine()) != null) {
                String[] array;
                if (s.startsWith("#") || s.equals("") || (array = s.split(" "))[0].length() <= 1) continue;
                map.put(array[0], array[1]);
            }
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> loadAsSet(String path) {
        try {
            HashSet<String> set = new HashSet<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(KrovetzStemmer.class.getClassLoader().getResourceAsStream(path)));
            if (!path.endsWith(OPTIMIZED_FILE_EXT)) {
                String s = null;
                while ((s = reader.readLine()) != null) {
                    if (s.startsWith("#") || s.length() <= 1) continue;
                    set.add(s);
                }
                return set;
            }
            String s = null;
            while ((s = reader.readLine()) != null) {
                String[] array = s.split(" ");
                set.addAll(Arrays.asList(array));
            }
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AlEndings
    implements StemmingAction {
        private AlEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 2) {
                return word;
            }
            if (word.endsWith("al")) {
                word.setSuffixLength(2);
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                if (word.hasDoubleConsonant(word.length() - word.getSuffix().length() - 1)) {
                    word.trimEnd(word.getSuffix().length() + 1);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix(word.getString().substring(word.length() - 1));
                    word.setSuffixLength(0);
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("um");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("al");
                if (word.getString().endsWith("ical")) {
                    word.trimEnd(4);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.addEndOfStemmed("y");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setEndOfStemmed("i");
                    word.addEndOfStemmed("c");
                    assert (word.getSuffixLength() == 0);
                    return word;
                }
                if (word.endsWith("ial")) {
                    word.trimEnd(3);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix("ial");
                    word.setSuffixLength(2);
                }
            }
            return word;
        }
    }

    private static class Aspect
    implements StemmingAction {
        private Aspect() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 5) {
                return word;
            }
            if (word.endsWith("ing")) {
                word.setSuffixLength(3);
                if (word.hasVowelInStem()) {
                    word.setSuffix("e");
                    String dep = null;
                    dep = KrovetzStemmer.getdep(word);
                    if (dep != null && !KrovetzStemmer.isExceptionalWord(dep)) {
                        return word;
                    }
                    word.setSuffix("");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    assert (word.getSuffixLength() == 0);
                    if (word.hasDoubleConsonant(word.length() - 1)) {
                        word.trimEnd(1);
                        if (KrovetzStemmer.containsInDictionary(word)) {
                            return word;
                        }
                        word.setSuffix(word.getString().substring(word.length() - 1));
                        return word;
                    }
                    if (word.isConsonant(word.length() - 1) && word.isConsonant(word.length() - 2)) {
                        return word;
                    }
                    word.setSuffix("e");
                    return word;
                }
            }
            return word;
        }
    }

    private static class BleEndings
    implements StemmingAction {
        private BleEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ble")) {
                word.setSuffixLength(3);
                if (!word.endsWith("able") && !word.endsWith("ible")) {
                    return word;
                }
                String wordChar = word.getString().substring(word.length() - 4, word.length() - 3);
                assert (wordChar.equals("a") || wordChar.equals("i"));
                word.trimEnd(4);
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                if (word.hasDoubleConsonant(word.length() - 1)) {
                    word.trimEnd(1);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    assert (word.getSuffixLength() == 0);
                    word.setSuffix(word.getString().substring(word.length() - 1));
                    word.setSuffixLength(0);
                }
                assert (word.getSuffixLength() == 0);
                word.setSuffix("e");
                word.setSuffixLength(0);
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                assert (word.getSuffixLength() == 0);
                word.setSuffixLength(1);
                word.setSuffix("ate");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix(String.valueOf(wordChar) + "ble");
            }
            return word;
        }
    }

    private static class ErOfOrEndings
    implements StemmingAction {
        private ErOfOrEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 2) {
                return word;
            }
            if (word.endsWith("izer")) {
                word.setSuffixLength(4);
                word.setSuffix("ize");
                return word;
            }
            if (word.endsWith("er") || word.endsWith("or")) {
                word.setSuffixLength(2);
                String wordChar = word.getString().substring(word.length() - 2, word.length() - 1);
                assert (wordChar.equals("e") || wordChar.equals("o"));
                if (word.hasDoubleConsonant(word.length() - word.getSuffix().length() - 1)) {
                    word.trimEnd(word.getSuffix().length() + 1);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix(word.getString().substring(word.length() - 1));
                    word.setSuffixLength(0);
                    word.setSuffix(String.valueOf(wordChar) + "r");
                }
                assert (word.getSuffixLength() == 2);
                if (word.getString().endsWith("ier")) {
                    word.setSuffix();
                    word.setEndOfStemmed("y");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setEndOfStemmed("i");
                    word.setSuffix("er");
                }
                if (word.getString().endsWith("eer")) {
                    word.trimEnd(word.getSuffix().length() + 1);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix("eer");
                    word.setSuffixLength(2);
                }
                word.setSuffix(wordChar);
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix(String.valueOf(wordChar) + "r");
            }
            return word;
        }
    }

    private static class IcEndings
    implements StemmingAction {
        private IcEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 2) {
                return word;
            }
            if (word.endsWith("ic")) {
                word.setSuffixLength(2);
                word.setSuffix("ical");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("y");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ic");
            }
            return word;
        }
    }

    private static class IonEndings
    implements StemmingAction {
        private IonEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ization")) {
                word.setSuffixLength(7);
                word.setSuffix("ize");
                return word;
            }
            if (word.endsWith("ition")) {
                word.setSuffixLength(5);
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ition");
            }
            if (word.endsWith("ation")) {
                word.setSuffixLength(5);
                word.setSuffix("ate");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ation");
            }
            if (word.endsWith("ication")) {
                word.setSuffixLength(7);
                word.setSuffix("y");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ication");
            }
            if (word.endsWith("ion")) {
                word.setSuffixLength(3);
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ion");
            }
            return word;
        }
    }

    private static class IsmEndings
    implements StemmingAction {
        private IsmEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ism")) {
                word.setSuffixLength(3);
                word.setSuffix();
            }
            return word;
        }
    }

    private static class ItyEndings
    implements StemmingAction {
        private ItyEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ity")) {
                word.setSuffixLength(3);
                word.setSuffix("");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ity");
                assert (word.getSuffixLength() == 3);
                if (word.getString().endsWith("ility")) {
                    word.setSuffix("");
                    word.setEndOfStemmed("le");
                    return word;
                }
                assert (word.getSuffixLength() == 3);
                if (word.getString().endsWith("ivity")) {
                    word.setSuffix("e");
                    return word;
                }
                assert (word.getSuffixLength() == 3);
                if (word.getString().endsWith("ality")) {
                    word.setSuffix("");
                    return word;
                }
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("");
            }
            return word;
        }
    }

    private static class IveEndings
    implements StemmingAction {
        private IveEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ive")) {
                word.setSuffixLength(3);
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ive");
                if (word.endsWith("ative")) {
                    word.setSuffixLength(5);
                    word.setSuffix("e");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix();
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix("ative");
                    word.setSuffixLength(3);
                }
                word.setSuffix("ion");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ive");
            }
            return word;
        }
    }

    private static class IzeEndings
    implements StemmingAction {
        private IzeEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ize")) {
                word.setSuffixLength(3);
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ize");
                if (word.hasDoubleConsonant(word.length() - word.getSuffix().length() - 1)) {
                    word.trimEnd(word.getSuffix().length() + 1);
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix(word.getString().substring(word.length() - 1));
                    word.setSuffixLength(0);
                }
                word.setSuffix("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ize");
            }
            return word;
        }
    }

    private static class LyEndings
    implements StemmingAction {
        private LyEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 2) {
                return word;
            }
            if (word.endsWith("ly")) {
                word.setSuffixLength(2);
                word.setSuffix("le");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                if (word.getString().endsWith("al")) {
                    return word;
                }
                word.setSuffix("ly");
                if (word.getString().endsWith("ably")) {
                    word.setSuffix("le");
                    return word;
                }
                assert (word.getSuffixLength() == 2);
                if (word.getString().endsWith("ily")) {
                    word.setSuffix();
                    word.setEndOfStemmed("y");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setEndOfStemmed("i");
                    word.setSuffix("ly");
                }
                assert (word.getSuffixLength() == 2);
                word.setSuffix();
            }
            return word;
        }
    }

    private static class MentEndings
    implements StemmingAction {
        private MentEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 4) {
                return word;
            }
            if (word.endsWith("ment")) {
                word.setSuffixLength(4);
                word.setSuffix();
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("ment");
            }
            return word;
        }
    }

    private static class NceEndings
    implements StemmingAction {
        private NceEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("nce")) {
                if (!word.endsWith("ence") && !word.endsWith("ance")) {
                    return word;
                }
                word.setSuffixLength(3);
                String wordChar = word.getString().substring(word.length() - 4, word.length() - 3);
                assert (wordChar.equals("e") || wordChar.equals("a"));
                word.setSuffix();
                word.setEndOfStemmed("e");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.trimEnd(1);
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.addEndOfStemmed(wordChar);
                word.setSuffix("nce");
            }
            return word;
        }
    }

    private static class NcyEndings
    implements StemmingAction {
        private NcyEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 3) {
                return word;
            }
            if (word.endsWith("ncy")) {
                if (!word.endsWith("ency") && !word.endsWith("ancy")) {
                    return word;
                }
                word.setSuffixLength(3);
                word.setSuffix("nt");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("nce");
            }
            return word;
        }
    }

    private static class NessEndings
    implements StemmingAction {
        private NessEndings() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 4) {
                return word;
            }
            if (word.endsWith("ness")) {
                word.setSuffixLength(4);
                word.setSuffix("");
                if (word.getString().endsWith("i")) {
                    word.setEndOfStemmed("y");
                }
            }
            return word;
        }
    }

    private static class PastTense
    implements StemmingAction {
        private PastTense() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.length() <= 4) {
                return word;
            }
            if (word.endsWith("ied")) {
                word.setSuffixLength(3);
                word.setSuffix("ie");
                if (KrovetzStemmer.containsInDictionary(word)) {
                    return word;
                }
                word.setSuffix("y");
                return word;
            }
            if (word.endsWith("ed")) {
                word.setSuffixLength(2);
                if (word.hasVowelInStem()) {
                    word.setSuffix("e");
                    String dep = null;
                    dep = KrovetzStemmer.getdep(word);
                    if (dep != null && !KrovetzStemmer.isExceptionalWord(dep)) {
                        return word;
                    }
                    word.setSuffix("");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    assert (word.getSuffixLength() == 0);
                    if (word.hasDoubleConsonant(word.length() - 1)) {
                        word.trimEnd(1);
                        if (KrovetzStemmer.containsInDictionary(word)) {
                            return word;
                        }
                        word.setSuffix(word.getString().substring(word.length() - 1));
                        return word;
                    }
                    if (word.getString().startsWith("un")) {
                        word.setSuffix("ed");
                        return word;
                    }
                    word.setSuffix("e");
                    return word;
                }
            }
            return word;
        }
    }

    private static class Plural
    implements StemmingAction {
        private Plural() {
        }

        @Override
        public StemmedString tryStem(StemmedString word) {
            if (word.endsWith("s")) {
                if (word.endsWith("ies")) {
                    word.setSuffixLength(3);
                    word.setSuffix("ie");
                    if (KrovetzStemmer.containsInDictionary(word)) {
                        return word;
                    }
                    word.setSuffix("y");
                } else {
                    if (word.endsWith("es")) {
                        word.setSuffixLength(2);
                        word.setSuffix("e");
                        if (KrovetzStemmer.containsInDictionary(word) && !word.getString().endsWith("sse")) {
                            return word;
                        }
                        word.setSuffix("");
                        if (KrovetzStemmer.containsInDictionary(word)) {
                            return word;
                        }
                        word.setSuffix("e");
                        return word;
                    }
                    if (word.length() > 3 && !word.getString().endsWith("ss") && !word.endsWith("ous")) {
                        word.setSuffixLength(1);
                        word.setSuffix("");
                    }
                }
            }
            return word;
        }
    }

    private static class StemmedString {
        private String stemmed;
        private String suffix;
        private String connected;
        private boolean changed;

        public StemmedString(String input) {
            if (input == null) {
                throw new NullPointerException();
            }
            this.stemmed = input;
            this.suffix = "";
            this.connected = input;
            this.changed = false;
        }

        public boolean endsWith(String s) {
            return this.getConnectedString().endsWith(s);
        }

        void setSuffixLength(int len) {
            if (len < 0) {
                throw new IllegalArgumentException("len < 0:" + len);
            }
            String connected = this.getConnectedString();
            int delimIndex = connected.length() - len;
            this.setStemmedAndSuffix(connected.substring(0, delimIndex), connected.substring(delimIndex));
        }

        void setSuffix(String suffix) {
            if (suffix == null) {
                throw new NullPointerException();
            }
            this.suffix = suffix;
            this.changed = true;
        }

        void setSuffix() {
            this.suffix = "";
            this.changed = true;
        }

        void setEndOfStemmed(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            this.stemmed = String.valueOf(this.stemmed.substring(0, this.stemmed.length() - s.length())) + s;
            this.changed = true;
        }

        void addEndOfStemmed(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            assert (this.suffix.equals(""));
            this.stemmed = String.valueOf(this.stemmed) + s;
            this.changed = true;
        }

        int getSuffixLength() {
            return this.suffix.length();
        }

        public String getString() {
            return this.getConnectedString();
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void trimEnd(int len) {
            if (len < 0 || len >= this.length()) {
                throw new IndexOutOfBoundsException("index:" + String.valueOf(len) + "  " + this.toString());
            }
            this.changed = true;
            if (this.suffix.length() > len) {
                this.suffix = this.suffix.substring(0, this.suffix.length() - len);
            } else {
                this.stemmed = this.stemmed.substring(0, this.stemmed.length() - len + this.suffix.length());
                this.suffix = "";
            }
        }

        private String getConnectedString() {
            if (this.changed) {
                this.connected = String.valueOf(this.stemmed) + this.suffix;
                this.changed = false;
            }
            return this.connected;
        }

        private void setStemmedAndSuffix(String stem, String suf) {
            if (stem == null || suf == null) {
                throw new NullPointerException();
            }
            this.stemmed = stem;
            this.suffix = suf;
            this.changed = true;
        }

        public int length() {
            return this.getConnectedString().length();
        }

        public boolean hasDoubleConsonant(int index) {
            return AbstractStemmer.hasDoubleConsonant(this.getConnectedString(), index);
        }

        public boolean hasVowelInStem() {
            return AbstractStemmer.hasVowelInStem(this.getConnectedString());
        }

        private boolean isConsonant(int index) {
            return AbstractStemmer.isConsonant(this.getConnectedString(), index);
        }

        public String toString() {
            return "[StemmedString](stemmed)" + this.stemmed + " (suffix)" + this.suffix;
        }
    }

    static interface StemmingAction {
        public StemmedString tryStem(StemmedString var1);
    }
}

