/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.stemmer;

import net.trialpc.sticktools.stemmer.Stemmer;

public abstract class AbstractStemmer
implements Stemmer {
    protected static boolean isConsonant(char[] c, int index) {
        char ch = c[index];
        if (ch == 'a' || ch == 'e' || ch == 'i' || ch == 'o' || ch == 'u') {
            return false;
        }
        if (ch != 'y' || index == 0) {
            return true;
        }
        return !AbstractStemmer.isConsonant(c, index - 1);
    }

    protected static boolean isConsonant(CharSequence c, int index) {
        char ch = c.charAt(index);
        if (ch == 'a' || ch == 'e' || ch == 'i' || ch == 'o' || ch == 'u') {
            return false;
        }
        if (ch != 'y' || index == 0) {
            return true;
        }
        return !AbstractStemmer.isConsonant(c, index - 1);
    }

    protected static boolean hasDoubleConsonant(char[] c, int index) {
        if (index < 1) {
            return false;
        }
        if (c[index] != c[index - 1]) {
            return false;
        }
        return AbstractStemmer.isConsonant(c, index);
    }

    protected static boolean hasDoubleConsonant(CharSequence c, int index) {
        if (index < 1) {
            return false;
        }
        if (c.charAt(index) != c.charAt(index - 1)) {
            return false;
        }
        return AbstractStemmer.isConsonant(c, index);
    }

    protected static boolean hasVowelInStem(char[] c) {
        int length = c.length;
        int i = 0;
        while (i < length) {
            if (!AbstractStemmer.isConsonant(c, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean hasVowelInStem(CharSequence c) {
        int length = c.length();
        int i = 0;
        while (i < length) {
            if (!AbstractStemmer.isConsonant(c, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isVowel(char[] c, int index) {
        return !AbstractStemmer.isConsonant(c, index);
    }

    protected static boolean isVowel(CharSequence c, int index) {
        return !AbstractStemmer.isConsonant(c, index);
    }
}

