/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.trialpc.sticktools.model.AbstractModelBuilder;
import net.trialpc.sticktools.model.BaseSentence;
import net.trialpc.sticktools.model.DocCollection;
import net.trialpc.sticktools.model.LocalContextDocument;
import net.trialpc.sticktools.model.SentenceModel;

public class LCDocumentBuilder
extends AbstractModelBuilder<DocCollection<LocalContextDocument<SentenceModel>>> {
    private Map<String, DocumentBuilder> documents = new LinkedHashMap<String, DocumentBuilder>();

    public boolean add(String docid, String sentid, String sentence) {
        DocumentBuilder builder = this.documents.get(docid);
        if (builder == null) {
            builder = new DocumentBuilder(docid);
            this.documents.put(docid, builder);
        }
        return builder.add(sentid, sentence);
    }

    public boolean add(String docid, SentenceModel sentence) {
        DocumentBuilder builder = this.documents.get(docid);
        if (builder == null) {
            builder = new DocumentBuilder(docid);
            this.documents.put(docid, builder);
        }
        return builder.add(sentence);
    }

    @Override
    public DocCollection<LocalContextDocument<SentenceModel>> build() {
        DocCollection<LocalContextDocument<SentenceModel>> dc = new DocCollection<LocalContextDocument<SentenceModel>>();
        for (DocumentBuilder builder : this.documents.values()) {
            dc.addDocument(builder.build());
        }
        return DocCollection.unmodifiableInstance(dc);
    }

    private class DocumentBuilder {
        private LocalContextDocument<SentenceModel> d;

        public DocumentBuilder(String docid) {
            this.d = new LocalContextDocument(docid);
        }

        public boolean add(String sid, String document) {
            List<String> terms = LCDocumentBuilder.this.getTexts(document);
            BaseSentence s = new BaseSentence(sid);
            s.addTerms(terms);
            return this.d.addSentence(BaseSentence.unmodifiableSentence(s));
        }

        public boolean add(SentenceModel sentence) {
            return this.d.addSentence(sentence);
        }

        public LocalContextDocument<SentenceModel> build() {
            return this.d;
        }
    }
}

