/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.trialpc.sticktools.model.AbstractLangModel;
import net.trialpc.sticktools.model.StateChangeListener;
import net.trialpc.sticktools.model.StateChangeObservable;
import net.trialpc.sticktools.model.StateEvent;

public abstract class BaseModel
extends AbstractLangModel
implements StateChangeObservable {
    private Map<String, Integer> terms = new HashMap<String, Integer>();
    private transient int numOfTerms = -1;
    protected Collection<StateChangeListener> listeners;

    public BaseModel() {
        this(true);
    }

    public BaseModel(boolean notify) {
        if (notify) {
            this.listeners = new ArrayList<StateChangeListener>();
        }
    }

    public boolean addTerm(String t) {
        if (t.matches("^\\s*$")) {
            return false;
        }
        Integer i = this.terms.get(t);
        if (i == null) {
            this.terms.put(t, 1);
        } else {
            this.terms.put(t, i + 1);
        }
        if (this.numOfTerms >= 0) {
            ++this.numOfTerms;
        }
        this.notifyTermAdded(t);
        return true;
    }

    public void addTerms(Collection<String> c) {
        for (String t : c) {
            this.addTerm(t);
        }
    }

    public boolean isEmpty() {
        return this.numOfTerms() == 0;
    }

    @Override
    public int termCount(String term) {
        Integer i = this.terms.get(term);
        return i == null ? 0 : i;
    }

    @Override
    public int numOfTerms() {
        if (this.numOfTerms < 0) {
            this.numOfTerms = 0;
            for (int n : this.terms.values()) {
                this.numOfTerms += n;
            }
        }
        return this.numOfTerms;
    }

    @Override
    public Set<String> getVocabulary() {
        return new HashSet<String>(this.terms.keySet());
    }

    @Override
    public int numOfVocabulary() {
        return this.terms.size();
    }

    @Override
    public void addListener(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public String toString() {
        Set<Map.Entry<String, Integer>> set = this.terms.entrySet();
        StringBuilder s = new StringBuilder();
        String ret = "";
        String sysRet = System.getProperty("line.separator");
        for (Map.Entry<String, Integer> entry : set) {
            s.append(ret);
            s.append("term:");
            s.append(entry.getKey());
            s.append("\t\t");
            s.append("count:");
            s.append(entry.getValue());
            ret = sysRet;
        }
        return s.toString();
    }

    public int hashCode() {
        return this.terms.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseModel)) {
            return false;
        }
        BaseModel b = (BaseModel)o;
        return this.terms.equals(b.terms);
    }

    protected final void notify(StateEvent event) {
        if (this.listeners != null) {
            for (StateChangeListener parent : this.listeners) {
                parent.stateChanged(event);
            }
        }
    }

    private void notifyTermAdded(String term) {
        if (this.listeners != null) {
            StateEvent event = new StateEvent(this, 1, term);
            this.notify(event);
        }
    }

    protected Map<String, Integer> getTerms() {
        this.numOfTerms = -1;
        return this.terms;
    }

    protected void setTerms(Map<String, Integer> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.terms = t;
        this.numOfTerms = -1;
    }

    protected static Map<String, Integer> castMap(Object t) {
        return (Map)t;
    }

    protected static Collection<StateChangeListener> castCollection(Object t) {
        return (Collection)t;
    }
}

