/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.trialpc.sticktools.model.BaseModel;
import net.trialpc.sticktools.model.DocumentModel;
import net.trialpc.sticktools.model.StateChangeListener;
import net.trialpc.sticktools.model.StateChangeObservable;

public class BaseDocument
extends BaseModel
implements DocumentModel,
StateChangeObservable,
Comparable<DocumentModel>,
Serializable {
    private static final long serialVersionUID = -2566984664182589013L;
    private String documentId;

    public BaseDocument(String id) {
        if (id == null) {
            id = "";
        }
        this.documentId = id;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    public static BaseDocument unmodifiableDocument(BaseDocument d) {
        if (d == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableDocument(d);
    }

    @Override
    public int hashCode() {
        return this.documentId.hashCode() & super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDocument)) {
            return false;
        }
        BaseDocument d = (BaseDocument)o;
        if (!this.getDocumentId().equals(d.getDocumentId())) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(DocumentModel arg0) {
        return this.getDocumentId().compareTo(arg0.getDocumentId());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getTerms());
        out.writeObject(this.listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setTerms(BaseDocument.castMap(in.readObject()));
        this.listeners = BaseDocument.castCollection(in.readObject());
    }

    private static class UnmodifiableDocument
    extends BaseDocument {
        private static final long serialVersionUID = 3995200107176968605L;
        private transient Set<String> vocabulary = null;
        private int numOfVocabulary = -1;

        public UnmodifiableDocument(BaseDocument d) {
            super(d.getDocumentId());
            this.setTerms(Collections.unmodifiableMap(new HashMap<String, Integer>(d.getTerms())));
        }

        @Override
        public void addListener(StateChangeListener listener) {
        }

        @Override
        public boolean addTerm(String t) {
            throw new UnsupportedOperationException("the instance is unmodifiable");
        }

        @Override
        public void addTerms(Collection<String> c) {
            throw new UnsupportedOperationException("the instance is unmodifiable");
        }

        @Override
        public Set<String> getVocabulary() {
            if (this.vocabulary == null) {
                this.vocabulary = Collections.unmodifiableSet(this.getTerms().keySet());
            }
            return this.vocabulary;
        }

        @Override
        public int numOfVocabulary() {
            if (this.numOfVocabulary < 0) {
                this.numOfVocabulary = super.numOfVocabulary();
            }
            return this.numOfVocabulary;
        }

        @Override
        public boolean isModifiable() {
            return false;
        }
    }
}

