/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.Collection;
import net.trialpc.sticktools.Query;
import net.trialpc.sticktools.model.LangModel;

public abstract class AbstractLangModel
implements LangModel {
    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean containsTerms(Collection<String> c) {
        for (String s : c) {
            if (!this.containsTerm(s)) continue;
            return true;
        }
        return false;
    }

    public boolean contaisQueries(Collection<Query> q) {
        for (Query query : q) {
            if (!this.containsTerm(query.getQuery())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTerm(String term) {
        return this.getVocabulary().contains(term);
    }

    @Override
    public int numOfVocabulary() {
        return this.getVocabulary().size();
    }

    @Override
    public float termFrequency(String term) {
        float denom = this.numOfTerms();
        assert (denom >= 0.0f);
        return denom <= 0.0f ? 0.0f : (float)this.termCount(term) / denom;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        String sysRet = System.getProperty("line.separator");
        String ret = "";
        for (String term : this.getVocabulary()) {
            s.append(ret);
            s.append("term:");
            s.append(term);
            s.append("\t\t");
            s.append("count:");
            s.append(this.termCount(term));
            ret = sysRet;
        }
        return s.toString();
    }
}

