/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools;

import java.io.Serializable;

public class Query
implements Comparable<Query>,
Serializable {
    private static final long serialVersionUID = -7998921623786364062L;
    private final String query;
    private final float weight;

    public Query(String q) {
        this(q, 1.0f);
    }

    public Query(String q, float w) {
        if (q == null) {
            throw new NullPointerException();
        }
        if (q.equals("")) {
            throw new IllegalArgumentException("query is empty string");
        }
        if (Float.isNaN(w)) {
            throw new IllegalArgumentException("weight is NaN");
        }
        if (w < 0.0f) {
            throw new IllegalArgumentException("weight < 0:" + w);
        }
        this.query = q;
        this.weight = w;
    }

    public String getQuery() {
        return this.query;
    }

    public float getWeight() {
        return this.weight;
    }

    public static Query valueOf(String query) {
        return new Query(query);
    }

    public static Query valueOf(String query, float w) {
        return new Query(query, w);
    }

    public int hashCode() {
        return this.query.hashCode() & Float.floatToIntBits(this.weight);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query q = (Query)o;
        return q.getQuery().equals(this.getQuery()) && q.getWeight() == this.getWeight();
    }

    public String toString() {
        return "[" + this.query + ", " + this.weight + "]";
    }

    @Override
    public int compareTo(Query o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int key = this.getQuery().compareTo(o.getQuery());
        return key != 0 ? key : Float.compare(this.getWeight(), o.getWeight());
    }
}

