/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker;

import java.io.File;

/**
 * Value object for command line options
 * 
 * @author Y.Murakamin
 * 
 */
public final class CommandLineOption
{
	private File configFile;
	private File logPropertyFile;
	private File hsqldbDataFile = null;

	/**
	 * Set the file object of Sticker configuration file
	 * 
	 * @param configFilePath
	 *            Sticker configuration file
	 */
	public CommandLineOption(final File configFilePath)
	{
		this.configFile = configFilePath;
	}

	/**
	 * get the file object of Sticker configuration file
	 * 
	 * @return Sticker configuration file
	 */
	public File getConfigFile()
	{
		return configFile;
	}

	/**
	 * get the Directory at HSQLDB file storage destination
	 * 
	 * @return Directory at HSQLDB file storage destination
	 */
	public File getHsqldbDataFile()
	{
		return hsqldbDataFile;
	}

	/**
	 * get the Log4j Logg property file
	 * 
	 * @return Log4j Logg property file
	 */
	public File getLogPropertyFile()
	{
		return logPropertyFile;
	}

	/**
	 * When the Log4j property file is set, true is returned
	 * 
	 * @return When the Log4j property file is set, true is returned
	 */
	public boolean isLogPropertyFileSet()
	{
		return this.logPropertyFile != null;
	}

	/**
	 * set the file object of Sticker configuration file
	 * 
	 * @param configFile
	 *            Sticker configuration file
	 */
	public void setConfigFile(final File configFile)
	{
		this.configFile = configFile;
	}

	/**
	 * set the Directory at HSQLDB file storage destination
	 * 
	 * @param dataFile
	 *            HSQLDB file storage destination
	 */
	public void setHsqldbDataFile(final File dataFile)
	{
		this.hsqldbDataFile = dataFile;
	}

	/**
	 * set the Log4j Logg property file
	 * 
	 * @param logPropertyFile
	 *            Logg property file
	 */
	public void setLogPropertyFile(final File logPropertyFile)
	{
		this.logPropertyFile = logPropertyFile;
	}

}
