/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.csv;

/**
 * Handler that class that does I/O processing of CSV data should mount
 * 
 * @author Y.Murakamin
 * 
 */
public interface CSVDataHandler
{

	/**
	 * One CSV data line's worth is processed.
	 * 
	 * @param currentDatas
	 *            Array where data for processing is stored
	 * @throws Exception
	 * 
	 */
	void addCSVData(final String[] currentDatas) throws Exception;

	/**
	 * The character-code of the CSV file is acquired.
	 * 
	 * @return CSV file character-code name
	 */
	String getFileCharset();

	/**
	 * The quart character string of the CSV data is acquired.
	 * 
	 * @return Quart character string of CSV data
	 */
	char getQuote();

	/**
	 * The record delimiter of the CSV data is acquired.
	 * 
	 * @return Record delimiter of CSV data
	 * 
	 */
	char getSeparator();

	/**
	 * When the header exists, true is returned.
	 * 
	 * @return When the header exists, true is returned.
	 */
	boolean isHeader();
}
