/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.io.ICsvWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CSVContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCsvWriter
implements ICsvWriter {
    final StringBuilder sb = new StringBuilder();
    BufferedWriter outStream;
    int lineNo;
    CsvPreference preference;

    protected AbstractCsvWriter(Writer writer, CsvPreference csvPreference) {
        this.setPreferences(csvPreference);
        this.outStream = new BufferedWriter(writer);
        this.lineNo = 1;
    }

    @Override
    public void close() throws IOException {
        this.outStream.flush();
        this.outStream.close();
    }

    protected String escapeString(String string) {
        if (string.length() == 0) {
            return "";
        }
        this.sb.delete(0, this.sb.length());
        int n = this.preference.getDelimiterChar();
        char c = (char)this.preference.getQuoteChar();
        String string2 = this.preference.getEndOfLineSymbols();
        boolean bl = false;
        if (string.charAt(0) == ' ') {
            bl = true;
        }
        int n2 = string.length() - 1;
        for (int i = 0; i <= n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == n) {
                bl = true;
                this.sb.append(c2);
                continue;
            }
            if (c2 == c) {
                if (i == 0) {
                    this.sb.append(c);
                    this.sb.append(c);
                    bl = true;
                    continue;
                }
                this.sb.append(c);
                this.sb.append(c);
                bl = true;
                continue;
            }
            if (c2 == '\n') {
                bl = true;
                this.sb.append(string2);
                continue;
            }
            this.sb.append(c2);
        }
        if (bl) {
            return c + this.sb.toString() + c;
        }
        return this.sb.toString();
    }

    @Override
    public int getLineNumber() {
        return this.lineNo;
    }

    @Override
    public ICsvWriter setPreferences(CsvPreference csvPreference) {
        this.preference = csvPreference;
        return this;
    }

    protected void write(List<? extends Object> list) throws IOException {
        this.write(list.toArray());
    }

    protected void write(Object ... objectArray) throws IOException {
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        for (Object object : objectArray) {
            if (object == null) {
                throw new NullInputException("Object at position " + n + " is null", new CSVContext(this.getLineNumber(), n), (Throwable)null);
            }
            stringArray[n++] = object.toString();
        }
        this.write(stringArray);
    }

    protected void write(String ... stringArray) throws IOException {
        int n;
        ++this.lineNo;
        int n2 = this.preference.getDelimiterChar();
        switch (stringArray.length) {
            case 0: {
                throw new SuperCSVException("There is no content to write for line " + this.getLineNumber(), new CSVContext(this.getLineNumber(), 0));
            }
            case 1: {
                break;
            }
            default: {
                for (n = 0; n < stringArray.length - 1; ++n) {
                    this.outStream.write(this.escapeString(stringArray[n]));
                    this.outStream.write(n2);
                }
            }
        }
        this.outStream.write(this.escapeString(stringArray[n]));
        this.outStream.write(this.preference.getEndOfLineSymbols());
    }

    @Override
    public void writeHeader(String ... stringArray) throws IOException, SuperCSVException {
        this.write(stringArray);
    }
}

