/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.ClassCastInputCSVException;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class StrNotNullOrEmpty
extends CellProcessorAdaptor
implements StringCellProcessor {
    public StrNotNullOrEmpty() {
    }

    public StrNotNullOrEmpty(CellProcessor cellProcessor) {
        super(cellProcessor);
    }

    public Object execute(Object object, CSVContext cSVContext) {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                throw new SuperCSVException("unexpected empty string", cSVContext, this);
            }
        } else {
            throw new ClassCastInputCSVException(object, String.class, cSVContext, this);
        }
        return this.next.execute(object, cSVContext);
    }
}

