/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands.enums;

/**
 * 
 * Enumerated type who shows right or wrong of execution of child element before
 * child element is executed
 * 
 * @see net.murakmain.sticker.commands.ParentCommand
 * @author Y.Murakamin
 */
public enum PreChildCommandExecutionType
{
	/**
	 * child command execute
	 */
	CHILD_EXECUTE,
	/**
	 * child command not execute
	 */
	CHILD_NOT_EXECUTE;
}
