/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.murakamin.sticker.CommandLineOption;
import net.murakamin.sticker.CommandRunnerImpl;
import net.murakamin.sticker.Messages;
import net.murakamin.sticker.commands.StickerCommand;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Sticker
implements ErrorHandler {
    private static boolean debug = false;
    public static final String VERSION = Messages.getString("sticker.version");
    private final Log log = LogFactory.getLog(Sticker.class);

    public static boolean isDebug() {
        return debug;
    }

    public static void main(String[] args) throws Exception {
        Sticker instance = new Sticker();
        try {
            CommandLineOption opts = instance.parseCommandLineOption(args);
            if (opts.isLogPropertyFileSet()) {
                PropertyConfigurator.configure((URL)opts.getLogPropertyFile().toURL());
            }
            instance.doProcess(opts.getConfigFile(), opts.getHsqldbDataFile());
            System.exit(0);
        }
        catch (ParseException pe) {
            instance.showHelp(pe);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static void setDebug(boolean debug) {
        Sticker.debug = debug;
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        Option opt = null;
        opt = new Option(Messages.getString("sticker.help.cmd.short.help"), Messages.getString("sticker.help.cmd.long.help"), false, Messages.getString("sticker.help.cmd.helpmessage"));
        options.addOption(opt);
        opt = new Option(Messages.getString("sticker.help.cmd.short.log"), Messages.getString("sticker.help.cmd.long.log"), true, Messages.getString("sticker.help.cmd.logmessage"));
        options.addOption(opt);
        opt = new Option(Messages.getString("sticker.help.cmd.short.serialize"), Messages.getString("sticker.help.cmd.long.serialize"), true, Messages.getString("sticker.help.cmd.serializemessage"));
        options.addOption(opt);
        return options;
    }

    private void doProcess(File config, File dataFile) throws Exception {
        block11: {
            long start = 0L;
            StickerCommand stickerTag = null;
            CommandRunnerImpl runner = null;
            try {
                try {
                    Digester digester = DigesterLoader.createDigester((InputSource)new InputSource(Sticker.class.getResourceAsStream(Messages.getString("sticker.digesterrulepath"))));
                    digester.setErrorHandler((ErrorHandler)this);
                    digester.setSchema(Sticker.class.getResource(Messages.getString("sticker.schemapath")).toString());
                    digester.setValidating(true);
                    digester.setSchemaLanguage(Messages.getString("sticker.schemalanguage"));
                    stickerTag = (StickerCommand)digester.parse(config);
                    Sticker.setDebug(stickerTag.isDebug());
                    start = System.currentTimeMillis();
                    this.log.info(String.valueOf(Messages.getString("sticker.log.info.start")) + new SimpleDateFormat("  yyyy/MM/dd kk:mm:ss").format(new Date(start)));
                    this.log.info(String.valueOf(Messages.getString("sticker.log.info.engineVersion")) + VERSION);
                    if (dataFile == null) {
                        runner = new CommandRunnerImpl();
                        stickerTag.execute(runner);
                    } else {
                        runner = new CommandRunnerImpl(dataFile);
                        stickerTag.execute(runner);
                    }
                    long stop = System.currentTimeMillis();
                    this.log.info(String.valueOf(Messages.getString("sticker.log.info.success")) + new SimpleDateFormat("  yyyy/MM/dd kk:mm:ss").format(new Date(stop)) + "(" + (stop - start) / 1000L + "sec" + ")");
                }
                catch (Exception e) {
                    String causeCommand = Messages.getString("sticker.log.error.unknown");
                    String causeCommandName = Messages.getString("sticker.log.error.unknown");
                    String causeException = "";
                    if (e instanceof CommandExecutionException) {
                        causeCommand = ((CommandExecutionException)e).getCauseCommand().toString();
                        causeCommandName = ((CommandExecutionException)e).getCauseCommand().getClass().getName();
                        causeException = e.getCause() != null ? e.getCause().getMessage() : "";
                    }
                    this.log.error(String.valueOf(Messages.getString("sticker.log.error.error")) + e.getMessage() + SystemUtils.LINE_SEPARATOR + ":" + causeException + SystemUtils.LINE_SEPARATOR + Messages.getString("sticker.log.error.causeCommand") + causeCommandName + SystemUtils.LINE_SEPARATOR + Messages.getString("sticker.log.error.causeDescription") + SystemUtils.LINE_SEPARATOR + causeCommand);
                    long stop = System.currentTimeMillis();
                    this.log.info(String.valueOf(new SimpleDateFormat("  yyyy/MM/dd kk:mm:ss").format(new Date(stop))) + "(" + (stop - start) / 1000L + "sec" + ")");
                    System.exit(1);
                    if (stickerTag != null) {
                        stickerTag.postChildCommandExecute(runner);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (stickerTag != null) {
                    stickerTag.postChildCommandExecute(runner);
                }
                throw throwable;
            }
            if (stickerTag != null) {
                stickerTag.postChildCommandExecute(runner);
            }
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        System.exit(1);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.exit(1);
    }

    private CommandLineOption parseCommandLineOption(String[] args) throws ParseException, MalformedURLException {
        CommandLineOption result = null;
        BasicParser parser = new BasicParser();
        Options opt = this.createCommandLineOptions();
        CommandLine cmd = parser.parse(opt, args);
        if (cmd.getArgs().length == 0) {
            throw new ParseException(Messages.getString("sticker.exception.config_not_found"));
        }
        result = new CommandLineOption(new File(cmd.getArgs()[0]));
        if (cmd.hasOption(Messages.getString("sticker.help.cmd.long.log"))) {
            result.setLogPropertyFile(new File(cmd.getOptionValue(Messages.getString("sticker.help.cmd.long.log"))));
        }
        if (cmd.hasOption(Messages.getString("sticker.help.cmd.long.serialize"))) {
            result.setHsqldbDataFile(new File(cmd.getOptionValue(Messages.getString("sticker.help.cmd.long.serialize"))));
        }
        if (cmd.hasOption(Messages.getString("sticker.help.cmd.short.help"))) {
            throw new ParseException("");
        }
        return result;
    }

    private void showHelp(ParseException pe) throws IOException {
        StringBuffer footer = new StringBuffer();
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.serialize1"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.serialize2"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.helpmessage.footer1"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.helpmessage.footer2"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.helpmessage.footer3"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.helpmessage.footer4"));
        footer.append(SystemUtils.LINE_SEPARATOR);
        footer.append(Messages.getString("sticker.help.helpmessage.footer5"));
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Messages.getString("sticker.help.helpmessage.usage"), String.valueOf(Messages.getString("sticker.help.helpmessage.versioninfo")) + VERSION, this.createCommandLineOptions(), footer.toString(), true);
    }

    public void warning(SAXParseException exception) throws SAXException {
    }
}

