/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import java.util.HashMap;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class Required
extends CellProcessorAdaptor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    protected HashMap<Integer, Object> requireds = new HashMap();

    public Required(int n, CellProcessor cellProcessor) {
        this(n);
    }

    public Required(int ... nArray) {
        this.addValues(nArray);
    }

    public Required(int[] nArray, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.addValues(nArray);
    }

    protected void addValues(int[] nArray) throws SuperCSVException {
        for (int n : nArray) {
            if (this.requireds.containsKey(n)) {
                throw new SuperCSVException("Cannot accept two identical hash codes");
            }
            this.requireds.put(n, null);
        }
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException, ClassCastException {
        if (!this.requireds.containsKey(object.hashCode())) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : this.requireds.keySet()) {
                stringBuilder.append(n + ", ");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " has hashcode " + object.hashCode() + " which is not one of the required hash codes: " + stringBuilder.toString());
        }
        return this.next.execute(object, cSVContext);
    }
}

