/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.DatabaseConnectionProperties;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;
import org.apache.commons.lang.SystemUtils;

public class ServerCommand
implements Command,
DatabaseConnectionProperties {
    private boolean autoCommit = true;
    private String charset;
    private String driver;
    private String driverJarFileName;
    private String name;
    private String pass;
    private String url;
    private String user;

    private Connection createConnection(StickerContext context, DatabaseConnectionProperties props) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        ClassLoader loader = this.getClass().getClassLoader();
        if (this.getDriverJarFile() != null) {
            String driverJarName = StickerContextUtil.applyContextValiable(context, this.getDriverJarFile());
            File driverFileName = new File(driverJarName).getCanonicalFile();
            URL driverURL = driverFileName.toURL();
            loader = URLClassLoader.newInstance(new URL[]{driverURL}, this.getClass().getClassLoader());
        }
        String driverName = StickerContextUtil.applyContextValiable(context, props.getDriver());
        String user = StickerContextUtil.applyContextValiable(context, this.getUser());
        String pass = StickerContextUtil.applyContextValiable(context, this.getPass());
        Class<?> driverClass = Class.forName(driverName, true, loader);
        Driver driverInstance = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", pass);
        return driverInstance.connect(props.getUrl(), info);
    }

    public void execute(CommandRunner runner) throws Exception {
        try {
            Connection con = this.createConnection(runner.getStickerContext(), this);
            con.setAutoCommit(this.isAutoCommit());
            runner.getConnectionPool().setRemoteConnection(this.getName(), con);
            runner.run(this);
        }
        catch (Exception e) {
            throw new CommandExecutionException((ExecutableCommand)this, (Throwable)e);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverJarFile() {
        return this.driverJarFileName;
    }

    public String getName() {
        return this.name;
    }

    public String getPass() {
        return this.pass;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public VersionTerm getVersionTerm() {
        return VersionTerm.PERMANENT_COMMAND;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isDebugPrint() {
        return true;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDriverJarFile(String name) {
        this.driverJarFileName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<server> create connection:");
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" name:");
        buffer.append(this.getName());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" driver:");
        buffer.append(this.getDriver());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" url:");
        buffer.append(this.getUrl());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" user:");
        buffer.append(this.getUser());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" pass:");
        buffer.append(this.getPass());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" charset:");
        buffer.append(this.getCharset());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" autocommit:");
        buffer.append(this.isAutoCommit());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }
}

