/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.ConnectionPoolImpl;
import net.murakamin.sticker.ShutdownEventHandler;
import net.murakamin.sticker.ShutdownHook;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.StickerContextImpl;
import net.murakamin.sticker.commands.ChildCommandExceptionHandler;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.ExceptionCommand;
import net.murakamin.sticker.commands.ParentCommand;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRunner
implements ShutdownEventHandler {
    protected static boolean COMMAND_COMPLETE = true;
    protected static boolean CONTINUE_PROCESSING = false;
    private ExceptionCommand exceptionCommand;
    private boolean exceptionCommandSearched = false;
    private final Log log = LogFactory.getLog(CommandRunner.class);
    private final ConnectionPoolImpl pool = new ConnectionPoolImpl();

    public static List<Command> findCommand(List<Command> commands, Class<? extends Command> target) {
        ArrayList<Command> result = new ArrayList<Command>();
        for (Command cmd : commands) {
            if (cmd instanceof ParentCommand) {
                result.addAll(CommandRunner.findCommand(((ParentCommand)cmd).getChildlen(), target));
            }
            if (!target.equals(cmd.getClass())) continue;
            result.add(cmd);
        }
        return result;
    }

    protected CommandRunner() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    public void run(Command target) throws Exception {
        this.run(target, HSQLDB_MODE.inmemory, null);
    }

    /*
     * Unable to fully structure code
     */
    private void run(Command target, HSQLDB_MODE mode, File dataFile) throws Exception {
        block13: {
            context = new StickerContextImpl();
            try {
                block14: {
                    try {
                        if (Sticker.isDebug()) {
                            Logger.getLogger(CommandRunner.class).setLevel(Level.DEBUG);
                        }
                        if (HSQLDB_MODE.inmemory == mode) {
                            this.pool.connectToHsqlDb();
                        } else {
                            this.pool.connectToHsqlDb(dataFile);
                        }
                        this.run(this.pool, context, target);
                        break block13;
                    }
                    catch (Exception e) {
                        if (this.exceptionCommand == null) break block14;
                        this.exceptionCommand.execute(this.pool, context);
                        ** for (cmd : this.exceptionCommand.getChildlen())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.run(this.pool, context, cmd);
                        continue;
                    }
lbl18:
                    // 1 sources

                    this.exceptionCommand = null;
                }
                throw e;
            }
            finally {
                try {
                    this.pool.closeRemoteConnections();
                }
                catch (Exception e) {
                    throw new CommandExecutionException(e);
                }
                this.pool.disConnectToHsqlDb();
            }
        }
    }

    public void run(Command target, File dataFile) throws Exception {
        this.run(target, HSQLDB_MODE.inprocess, dataFile);
    }

    private void run(ConnectionPool pool, StickerContext context, Command target) throws Exception {
        if (!this.exceptionCommandSearched && target instanceof ParentCommand) {
            List<Command> result = CommandRunner.findCommand(((ParentCommand)target).getChildlen(), ExceptionCommand.class);
            if (result.size() > 0) {
                this.exceptionCommand = (ExceptionCommand)result.get(0);
            }
            this.exceptionCommandSearched = true;
        }
        if (target instanceof ExceptionCommand) {
            return;
        }
        if (Sticker.isDebug() && target.isDebugPrint()) {
            this.log.debug(target.toString());
        }
        try {
            target.execute(pool, context);
            if (target instanceof ParentCommand) {
                ((ParentCommand)target).preChildCommandExecute(pool, context);
                for (Command cmd : ((ParentCommand)target).getChildlen()) {
                    this.run(pool, context, cmd);
                }
                ((ParentCommand)target).postChildCommandExecute(pool, context);
            }
        }
        catch (Exception e) {
            if (target instanceof ChildCommandExceptionHandler) {
                try {
                    ((ChildCommandExceptionHandler)((Object)target)).handleException(pool, context);
                }
                catch (Exception ex) {
                    throw new CommandExecutionException(target, (Throwable)ex);
                }
            }
            throw e;
        }
    }

    @Override
    public void shutdownEvent() throws Exception {
        try {
            this.pool.closeRemoteConnections();
        }
        finally {
            this.pool.disConnectToHsqlDb();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HSQLDB_MODE {
        inprocess,
        inmemory;

    }
}

