/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import net.murakamin.csv.CSVDataHandler;
import net.murakamin.csv.exception.CSVParseException;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVParser {
    public static final char QUOTE_NONE = '\u0000';
    private final CSVDataHandler handler;

    public CSVParser(CSVDataHandler importTarget) {
        this.handler = importTarget;
    }

    public void doParse(File source) throws CSVParseException {
        CsvListReader reader = null;
        List currentDatas = null;
        try {
            CsvPreference pref = new CsvPreference(this.handler.getQuot(), (int)this.handler.getSeparator(), "\n");
            reader = new CsvListReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), this.handler.getFileCharset())), pref);
            if (this.handler.isHeader()) {
                reader.getCSVHeader(true);
            }
            while ((currentDatas = reader.read()) != null) {
                this.handler.addCSVData(currentDatas.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            throw new CSVParseException(reader.getLineNumber(), (Throwable)e);
        }
    }

    public void doParse(ResultSet source) throws CSVParseException {
        int lineNo = 0;
        String[] currentDatas = null;
        try {
            lineNo = 1;
            while (source.next()) {
                currentDatas = this.parseStrings(source);
                this.handler.addCSVData(currentDatas);
                ++lineNo;
            }
        }
        catch (Exception e) {
            throw new CSVParseException(lineNo, (Throwable)e);
        }
    }

    private String[] parseStrings(ResultSet rs) throws UnsupportedEncodingException, SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] csvData = null;
        csvData = new String[columnCount];
        int i = 1;
        while (i < columnCount + 1) {
            Object o = rs.getObject(i);
            csvData[i - 1] = null;
            if (o != null) {
                csvData[i - 1] = o.toString();
            }
            ++i;
        }
        return csvData;
    }
}

