/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import net.murakamin.csv.CSVDataHandler;
import net.murakamin.csv.CSVParser;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryImportCommand
implements Command,
CSVDataHandler {
    private final Log log = LogFactory.getLog(CommandRunner.class);
    private ConnectionPool conPool;
    private String destination;
    private String sql;

    public void addCSVData(String[] currentDatas) throws Exception {
        String sql = this.createInsertPrepareStatement(this.getDestination(), currentDatas);
        PreparedStatement stmt = null;
        Connection targetConnection = null;
        targetConnection = this.conPool.getRemoteConnection();
        stmt = targetConnection.prepareStatement(sql);
        int parameterIndex = 1;
        String[] stringArray = currentDatas;
        int n = currentDatas.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            stmt.setObject(parameterIndex, field);
            ++parameterIndex;
            ++n2;
        }
        if (Sticker.isDebug()) {
            this.log.debug(stmt);
        }
        try {
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    public void execute(ConnectionPool pool, StickerContext context) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                this.conPool = pool;
                Connection sourceConnection = this.conPool.getLocalConnection();
                stmt = sourceConnection.prepareStatement(this.getSql());
                rs = stmt.executeQuery();
                new CSVParser(this).doParse(rs);
            }
            catch (Exception e) {
                throw new CommandExecutionException((Command)this, (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFileCharset() {
        throw new UnsupportedOperationException();
    }

    public char getQuot() {
        throw new UnsupportedOperationException();
    }

    public char getSeparator() {
        throw new UnsupportedOperationException();
    }

    public String getSource() {
        throw new UnsupportedOperationException();
    }

    public String getSql() {
        return this.sql;
    }

    public String getTarget() {
        throw new UnsupportedOperationException();
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isHeader() {
        throw new UnsupportedOperationException();
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setFileCharset(String charset) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(boolean header) {
        throw new UnsupportedOperationException();
    }

    public void setQuot(char quot) {
        throw new UnsupportedOperationException();
    }

    public void setSeparator(char separatorType) {
        throw new UnsupportedOperationException();
    }

    public void setSource(String source) {
        throw new UnsupportedOperationException();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTarget(String t) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<import> import execute:\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append("\n");
        buffer.append(" query:");
        buffer.append(this.getSql());
        buffer.append("\n");
        return buffer.toString();
    }
}

