/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.DatabaseConnectionProperties;

public class ServerCommand
implements Command,
DatabaseConnectionProperties {
    private boolean autoCommit;
    private String charset;
    private String driver;
    private String driverJarFileName;
    private String name;
    private String pass;
    private String url;
    private String user;

    private Connection createConnection(DatabaseConnectionProperties props) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        ClassLoader loader = this.getClass().getClassLoader();
        if (this.getDriverJarFile() != null) {
            File driverFileName = new File(this.getDriverJarFile()).getCanonicalFile();
            URL driverURL = driverFileName.toURL();
            loader = URLClassLoader.newInstance(new URL[]{driverURL}, this.getClass().getClassLoader());
        }
        Class<?> driverClass = Class.forName(props.getDriver(), true, loader);
        Driver driverInstance = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.put("user", props.getUser());
        info.put("password", props.getPass());
        return driverInstance.connect(props.getUrl(), info);
    }

    public void execute(ConnectionPool pool, StickerContext context) throws Exception {
        Connection con = this.createConnection(this);
        con.setAutoCommit(this.isAutoCommit());
        pool.setRemoteConnection(this.getName(), con);
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverJarFile() {
        return this.driverJarFileName;
    }

    public String getName() {
        return this.name;
    }

    public String getPass() {
        return this.pass;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDriverJarFile(String name) {
        this.driverJarFileName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<server> create connection:\n");
        buffer.append(" name:");
        buffer.append(this.getName());
        buffer.append("\n");
        buffer.append(" driver:");
        buffer.append(this.getDriver());
        buffer.append("\n");
        buffer.append(" url:");
        buffer.append(this.getUrl());
        buffer.append("\n");
        buffer.append(" user:");
        buffer.append(this.getUser());
        buffer.append("\n");
        buffer.append(" pass:");
        buffer.append(this.getPass());
        buffer.append("\n");
        buffer.append(" charset:");
        buffer.append(this.getCharset());
        buffer.append("\n");
        buffer.append(" autocommit:");
        buffer.append(this.isAutoCommit());
        buffer.append("\n");
        return buffer.toString();
    }
}

