/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.argius.stew.Logger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(DaemonThreadFactory.class);
    private static final AtomicInteger count = new AtomicInteger();
    private static volatile ThreadFactory instance;

    private DaemonThreadFactory() {
    }

    public static ThreadFactory getInstance() {
        if (instance == null) {
            instance = new DaemonThreadFactory();
        }
        return instance;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String string = String.format("ChildDaemon%d-of-%s", count.getAndIncrement(), Thread.currentThread());
        if (log.isDebugEnabled()) {
            log.debug("create thread: name=" + string);
        }
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(true);
        return thread;
    }

    public static void execute(Runnable runnable) {
        DaemonThreadFactory.getInstance().newThread(runnable).start();
    }
}

