/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.argius.stew.Bootstrap;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Environment;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ResultSetReference;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.Importer;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionKey;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.ValueTransporter;
import net.argius.stew.ui.window.WindowLauncher;

final class WindowOutputProcessor
extends JFrame
implements OutputProcessor,
AnyActionListener {
    private static final Logger log = Logger.getLogger(WindowOutputProcessor.class);
    private static final ResourceManager res = ResourceManager.getInstance(WindowOutputProcessor.class);
    private final AnyAction invoker;
    private final WindowLauncher launcher;
    private final ResultSetTable resultSetTable;
    private final ConsoleTextArea textArea;
    private Environment env;
    private File currentDirectory;
    private String postProcessMode;

    WindowOutputProcessor(WindowLauncher windowLauncher, ResultSetTable resultSetTable, ConsoleTextArea consoleTextArea) {
        this.launcher = windowLauncher;
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.invoker = new AnyAction(this);
    }

    @Override
    public void output(Object object) {
        try {
            if (object instanceof ResultSet) {
                this.outputResult(new ResultSetReference((ResultSet)object, ""));
                return;
            }
            if (object instanceof ResultSetReference) {
                this.outputResult((ResultSetReference)object);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("WindowOutputProcessor", sQLException);
        }
        String string = object instanceof Prompt ? object.toString() : String.format("%s%n", object);
        AnyAction anyAction = new AnyAction(this.textArea);
        AnyActionEvent anyActionEvent = new AnyActionEvent((Object)this, (Object)ConsoleTextArea.ActionKey.outputMessage, WindowOutputProcessor.replaceEOL(string));
        anyAction.doLater("anyActionPerformed", anyActionEvent);
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.launcher.anyActionPerformed(new AnyActionEvent((Object)this, (Object)AnyActionKey.closeWindow, new Object[0]));
        }
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        log.atEnter("anyActionPerformed", anyActionEvent);
        try {
            if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.importFile})) {
                this.importIntoCurrentTable();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.exportFile})) {
                this.exportTableContent();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showAbout})) {
                this.showVersionInfo();
            } else {
                log.warn("not expected: Event=%s", anyActionEvent);
            }
        }
        catch (Exception exception) {
            log.error(exception);
            this.showErrorDialog(exception);
        }
        log.atExit("anyActionPerformed");
    }

    void setEnvironment(Environment environment) {
        this.env = environment;
        if (this.currentDirectory == null) {
            this.setCurrentDirectory(environment.getCurrentDirectory());
        }
    }

    void outputResult(ResultSetReference resultSetReference) throws SQLException {
        OutputProcessor outputProcessor = this.env.getOutputProcessor();
        this.invoker.doLater("clearResultSetTable", new Object[0]);
        ResultSet resultSet = resultSetReference.getResultSet();
        ColumnOrder columnOrder = resultSetReference.getOrder();
        boolean bl = columnOrder.size() > 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = bl ? columnOrder.size() : resultSetMetaData.getColumnCount();
        ResultSetTableModel resultSetTableModel = new ResultSetTableModel(resultSetReference);
        Vector<Object> vector = new Vector<Object>(n);
        ValueTransporter valueTransporter = ValueTransporter.getInstance("");
        int n2 = Bootstrap.getPropertyAsInt("net.argius.stew.rowcount.limit", Integer.MAX_VALUE);
        int n3 = 0;
        while (resultSet.next()) {
            if (n3 >= n2) {
                this.invoker.doLater("notifyOverLimit", n2);
                break;
            }
            ++n3;
            vector.clear();
            for (int i = 0; i < n; ++i) {
                int n4 = bl ? columnOrder.getOrder(i) : i + 1;
                vector.add(valueTransporter.getObject(resultSet, n4));
            }
            resultSetTableModel.addRow((Vector)vector.clone());
            if (this.env.getOutputProcessor() == outputProcessor) continue;
            throw new SQLException("interrupted");
        }
        this.invoker.doLater("showResult", resultSetTableModel);
        resultSetReference.setRecordCount(resultSetTableModel.getRowCount());
    }

    private void clearResultSetTable() {
        Container container = this.resultSetTable.getParent();
        if (container != null && container.getParent() instanceof JScrollPane) {
            ((JScrollPane)container.getParent()).setCorner("UPPER_LEFT_CORNER", null);
        }
        this.resultSetTable.setVisible(false);
        this.resultSetTable.getTableHeader().setVisible(false);
        ((DefaultTableModel)this.resultSetTable.getModel()).setRowCount(0);
        this.resultSetTable.resetSortState();
    }

    private void notifyOverLimit(int n) {
        this.output(res.get("w.exceeded-limit", n));
    }

    private void showResult(ResultSetTableModel resultSetTableModel) {
        this.resultSetTable.setModel(resultSetTableModel);
        Container container = this.resultSetTable.getParent();
        if (container != null && container.getParent() instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container.getParent();
            ImageIcon imageIcon = Utilities.getImageIcon(String.format("linkable-%s.png", resultSetTableModel.isLinkable()));
            jScrollPane.setCorner("UPPER_LEFT_CORNER", new JLabel(imageIcon, 0));
        }
        this.resultSetTable.anyActionPerformed(new AnyActionEvent((Object)this, (Object)AnyActionKey.adjustColumnWidth, new Object[0]));
        this.resultSetTable.getTableHeader().setVisible(true);
        this.resultSetTable.doLayout();
        this.resultSetTable.setVisible(true);
    }

    String getPostProcessMode() {
        return this.postProcessMode;
    }

    void setPostProcessMode(String string) {
        String string2 = this.postProcessMode;
        this.postProcessMode = string;
        this.firePropertyChange("postProcessMode", string2, string);
    }

    void doPostProcess() {
        AnyAction anyAction = new AnyAction(this);
        if (this.isActive()) {
            anyAction.doLater("focusWindow", true);
            return;
        }
        String string = this.getClass().getName() + ".postprocess.";
        int n = Bootstrap.getPropertyAsInt(string + "count", 32);
        int n2 = Bootstrap.getPropertyAsInt(string + "range", 2);
        long l = Bootstrap.getPropertyAsInt(string + "interval", 50);
        switch (AnyActionKey.of(this.postProcessMode)) {
            case postProcessModeNone: {
                break;
            }
            case postProcessModeFocus: {
                anyAction.doLater("focusWindow", false);
                break;
            }
            case postProcessModeShake: {
                anyAction.doParallel("shakeWindow", n, n2, l);
                break;
            }
            case postProcessModeBlink: {
                anyAction.doParallel("blinkWindow", n, n2, l);
                break;
            }
            default: {
                log.warn("doPostProcess: postProcessMode=%s", this.postProcessMode);
            }
        }
    }

    void focusWindow(boolean bl) {
        if (bl) {
            this.toFront();
        }
        this.requestFocus();
        this.textArea.requestFocusInWindow();
    }

    void shakeWindow(int n, int n2, long l) {
        AnyAction anyAction = new AnyAction(new PostProcessAction(new byte[0]));
        anyAction.doLater("focusWindow", new Object[0]);
        int n3 = n >> 1 << 1;
        for (int i = 0; i < n3; ++i) {
            anyAction.doLater("shakeWindow", n2);
            Utilities.sleep(l);
        }
    }

    void blinkWindow(int n, int n2, long l) {
        byte[] byArray = new byte[]{0};
        PostProcessAction postProcessAction = new PostProcessAction(byArray);
        AnyAction anyAction = new AnyAction(new PostProcessAction(new byte[0]));
        anyAction.doLater("showComponent", postProcessAction);
        int n3 = (n / 45 + 1) * 45;
        for (int i = 0; i < n3; ++i) {
            byArray[0] = (byte)((Math.sin((float)i * 0.25f) + 1.0) * 32.0 * (double)n2);
            postProcessAction.repaint();
            Utilities.sleep(l);
        }
        anyAction.doLater("removeComponent", postProcessAction);
    }

    void requestFocusToTextAreaInWindow() {
        this.textArea.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importIntoCurrentTable() throws IOException, SQLException {
        ResultSetTableModel resultSetTableModel;
        if (this.env.getCurrentConnection() == null) {
            JOptionPane.showMessageDialog(this, res.get("w.not-connect", new Object[0]));
            return;
        }
        TableModel tableModel = this.resultSetTable.getModel();
        boolean bl = tableModel instanceof ResultSetTableModel ? (resultSetTableModel = (ResultSetTableModel)tableModel).isLinkable() && resultSetTableModel.isSameConnection(this.env.getCurrentConnection()) : false;
        if (!bl) {
            JOptionPane.showMessageDialog(this, res.get("w.import-target-not-available", new Object[0]));
            return;
        }
        resultSetTableModel = (ResultSetTableModel)tableModel;
        assert (this.currentDirectory != null);
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setDialogTitle(res.get("Action.import", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setCurrentDirectory(file);
        Importer importer = Importer.getImporter(file);
        try {
            Object[] objectArray;
            while ((objectArray = importer.nextRow()).length != 0) {
                resultSetTableModel.addUnlinkedRow(objectArray);
                resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
            }
        }
        finally {
            importer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportTableContent() throws IOException {
        assert (this.currentDirectory != null);
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setDialogTitle(res.get("Action.export", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showSaveDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setCurrentDirectory(file);
        if (file.exists() && JOptionPane.showConfirmDialog(this, res.get("i.confirm-overwrite", file), null, 0) != 0) {
            return;
        }
        Exporter exporter = Exporter.getExporter(file);
        try {
            TableColumnModel tableColumnModel = this.resultSetTable.getTableHeader().getColumnModel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (TableColumn serializable2 : Collections.list(tableColumnModel.getColumns())) {
                arrayList.add(serializable2.getHeaderValue());
            }
            exporter.addHeader(arrayList.toArray());
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.resultSetTable.getModel();
            Vector<Vector> vector = defaultTableModel.getDataVector();
            for (Vector vector2 : vector) {
                exporter.addRow(vector2.toArray());
            }
        }
        finally {
            exporter.close();
        }
        JOptionPane.showMessageDialog(this, res.get("i.exported", new Object[0]));
    }

    private void showVersionInfo() {
        ImageIcon imageIcon = new ImageIcon();
        if (this.getIconImage() != null) {
            imageIcon.setImage(this.getIconImage());
        }
        String string = res.get(".about", Bootstrap.getVersion());
        JOptionPane.showMessageDialog(this, string, null, -1, imageIcon);
    }

    private void setCurrentDirectory(File file) {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        assert (file2.isDirectory());
        this.currentDirectory = file2;
    }

    Object showInputDialog(String string, String string2, Object[] objectArray, Object object) {
        return WindowOutputProcessor.showInputDialog(this, string, string2, objectArray, object);
    }

    static Object showInputDialog(Component component, String string, String string2, Object[] objectArray, Object object) {
        JOptionPane jOptionPane = new JOptionPane(string, -1, 2);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object);
        jOptionPane.setComponentOrientation(component.getComponentOrientation());
        JDialog jDialog = jOptionPane.createDialog(component, string2);
        Dimension dimension = jDialog.getSize();
        if (dimension.width > component.getWidth() || dimension.height > component.getHeight()) {
            if (dimension.width > component.getWidth()) {
                dimension.width = (int)((double)component.getWidth() * 0.95);
            }
            if (dimension.height > component.getHeight()) {
                dimension.height = (int)((double)component.getHeight() * 0.95);
            }
            jDialog.setPreferredSize(dimension);
            jDialog.setSize(dimension);
            jDialog.setLocationRelativeTo(component);
        }
        jOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object2 = jOptionPane.getInputValue();
        return object2 == JOptionPane.UNINITIALIZED_VALUE ? null : object2;
    }

    void showInformationMessageDialog(String string, String string2) {
        WindowOutputProcessor.showInformationMessageDialog(this, string, string2);
    }

    static void showInformationMessageDialog(Component component, String string, String string2) {
        JTextArea jTextArea = new JTextArea(string, 6, 60);
        WindowOutputProcessor.setupReadOnlyTextArea(jTextArea);
        JOptionPane.showMessageDialog(component, new JScrollPane(jTextArea), string2, 1);
    }

    void showErrorDialog(Throwable throwable) {
        WindowOutputProcessor.showErrorDialog(this, throwable);
    }

    static void showErrorDialog(final Component component, Throwable throwable) {
        Object object;
        Object object2;
        String string;
        String string2;
        log.atEnter("showErrorDialog", new Object[0]);
        log.warn(throwable, (Object)"");
        if (throwable == null) {
            string2 = res.get("e.error-no-detail", new Object[0]);
            string = "";
        } else {
            string2 = throwable.getMessage();
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable.printStackTrace((PrintWriter)object);
            string = WindowOutputProcessor.replaceEOL(object2.toString());
        }
        object2 = res.get("e.error", new Object[0]);
        class ErrorDialogTask
        implements Runnable {
            final /* synthetic */ String val$title;

            ErrorDialogTask() {
                this.val$title = string3;
            }

            @Override
            public void run() {
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JScrollPane(WindowOutputProcessor.setupReadOnlyTextArea(new JTextArea(string2, 2, 60))), "North");
                jPanel.add((Component)new JScrollPane(WindowOutputProcessor.setupReadOnlyTextArea(new JTextArea(string, 6, 60))), "Center");
                JDialog jDialog = new JOptionPane(jPanel, 0).createDialog(component, this.val$title);
                jDialog.setResizable(true);
                jDialog.setVisible(true);
                jDialog.dispose();
            }
        }
        object = new ErrorDialogTask();
        if (EventQueue.isDispatchThread()) {
            ((ErrorDialogTask)object).run();
        } else {
            EventQueue.invokeLater((Runnable)object);
        }
        log.atExit("showErrorDialog");
    }

    private static String replaceEOL(String string) {
        return string.replaceAll("\\\r\\\n?", "\n");
    }

    static JTextArea setupReadOnlyTextArea(JTextArea jTextArea) {
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(false);
        jTextArea.setLineWrap(false);
        jTextArea.setOpaque(false);
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
        return jTextArea;
    }

    static final class Bypass
    implements OutputProcessor {
        private OutputProcessor op;
        private volatile boolean closed;

        Bypass(OutputProcessor outputProcessor) {
            this.op = outputProcessor;
        }

        @Override
        public void output(Object object) {
            if (!this.closed) {
                this.op.output(object);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    final class PostProcessAction
    extends JPanel {
        int sign = -1;
        byte[] alpha;
        Frame frame = JOptionPane.getRootFrame();

        PostProcessAction(byte ... byArray) {
            this.alpha = byArray;
        }

        void focusWindow() {
            WindowOutputProcessor.this.requestFocusToTextAreaInWindow();
        }

        void shakeWindow(int n) {
            this.sign *= -1;
            this.setLocation(this.getX() + n * this.sign, this.getY() + 0);
        }

        void showComponent(JComponent jComponent) {
            WindowOutputProcessor.this.requestFocusToTextAreaInWindow();
            WindowOutputProcessor.this.setGlassPane(jComponent);
            jComponent.setOpaque(false);
            jComponent.setVisible(true);
        }

        void removeComponent(JComponent jComponent) {
            jComponent.setVisible(false);
            this.remove(jComponent);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponents(graphics);
            graphics.setColor(new Color(0, 230, 46, this.alpha[0] & 0xFF));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

