/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ContextMenu;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.Utilities;

final class TextSearchPanel
extends JPanel
implements AnyActionListener {
    private static final ResourceManager res = ResourceManager.getInstance(TextSearchPanel.class);
    private final List<TextSearch> targets = new ArrayList<TextSearch>();
    private final JTextField text = new JTextField(20);
    private final JCheckBox useRegexCheck = new JCheckBox(res.get("useregex", new Object[0]));
    private final JCheckBox ignoreCaseCheck = new JCheckBox(res.get("ignorecase", new Object[0]));
    private TextSearch currentTarget;
    private boolean searchBackward;

    TextSearchPanel(JFrame jFrame) {
        this.setLayout(new FlowLayout(0, 1, 1));
        this.setVisible(false);
        final JButton jButton = new JButton(Utilities.getImageIcon("close.png"));
        JTextField jTextField = this.text;
        JButton jButton2 = new JButton(res.get("forward", new Object[0]));
        JButton jButton3 = new JButton(res.get("backward", new Object[0]));
        JCheckBox jCheckBox = this.useRegexCheck;
        final JCheckBox jCheckBox2 = this.ignoreCaseCheck;
        jButton.setToolTipText(res.get("close", new Object[0]));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setMargin(new Insets(1, 2, 1, 2));
        jButton2.setMargin(new Insets(0, 7, 0, 7));
        jButton3.setMargin(new Insets(0, 7, 0, 7));
        TextSearchPanel.changeFontSize(jCheckBox, 0.8f);
        TextSearchPanel.changeFontSize(jCheckBox2, 0.8f);
        this.add(TextSearchPanel.createFiller(2));
        this.add(jButton);
        this.add(TextSearchPanel.createFiller(2));
        this.add(new JLabel(res.get("label", new Object[0])));
        this.add(jTextField);
        this.add(TextSearchPanel.createFiller(1));
        this.add(jButton2);
        this.add(jButton3);
        this.add(jCheckBox);
        this.add(jCheckBox2);
        final FocusTraversalPolicy focusTraversalPolicy = jFrame.getFocusTraversalPolicy();
        class LayoutFocusTraversalPolicyImpl
        extends LayoutFocusTraversalPolicy {
            LayoutFocusTraversalPolicyImpl() {
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                if (component == jCheckBox2) {
                    return jButton;
                }
                return focusTraversalPolicy.getComponentAfter(container, component);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                if (component == jButton) {
                    return jCheckBox2;
                }
                return focusTraversalPolicy.getComponentBefore(container, component);
            }
        }
        jFrame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyImpl());
        ContextMenu.createForText(jTextField);
        this.bindEvent(jTextField, (Object)ActionKey.search, KeyStroke.getKeyStroke(10, 0));
        this.bindEvent(jButton, (Object)ActionKey.close);
        this.bindEvent(jButton2, (Object)ActionKey.forward);
        this.bindEvent(jButton3, (Object)ActionKey.backward);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        for (JComponent jComponent : new JComponent[]{jButton, jTextField, jButton2, jButton3, jCheckBox, jCheckBox2}) {
            this.bindEvent(jComponent, (Object)ActionKey.close, keyStroke);
        }
    }

    private void bindEvent(JButton jButton, Object object) {
        jButton.setActionCommand(String.valueOf(object));
        jButton.addActionListener(new AnyAction(this));
    }

    private void bindEvent(JComponent jComponent, Object object, KeyStroke keyStroke) {
        AnyAction anyAction = new AnyAction(jComponent);
        anyAction.bind((AnyActionListener)this, object, keyStroke);
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101) {
            this.validate();
        }
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        if (anyActionEvent.isAnyOf(new Object[]{ActionKey.close})) {
            this.setVisible(false);
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.search})) {
            this.startSearch();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.forward})) {
            this.setSearchBackward(false);
            this.startSearch();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.backward})) {
            this.setSearchBackward(true);
            this.startSearch();
        }
    }

    private static void changeFontSize(Component component, float f) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(0, (float)font.getSize() * f));
    }

    private static Component createFiller(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new JLabel(String.valueOf(cArray));
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            int n = this.text.getText().length();
            if (n > 0) {
                this.text.setSelectionStart(0);
                this.text.setSelectionEnd(n);
            }
            this.text.requestFocus();
        } else {
            for (TextSearch textSearch : this.targets) {
                textSearch.reset();
            }
            if (this.currentTarget instanceof Component) {
                Component component = (Component)((Object)this.currentTarget);
                component.requestFocus();
            }
        }
    }

    void addTarget(TextSearch textSearch) {
        this.targets.add(textSearch);
    }

    void removeTarget(TextSearch textSearch) {
        this.targets.remove(textSearch);
    }

    void setCurrentTarget(TextSearch textSearch) {
        this.currentTarget = textSearch;
    }

    void setSearchBackward(boolean bl) {
        this.searchBackward = bl;
    }

    /*
     * WARNING - void declaration
     */
    void startSearch() {
        String string = this.text.getText();
        if (string == null || string.length() == 0 || this.currentTarget == null) {
            return;
        }
        boolean bl = this.useRegexCheck.isSelected();
        boolean bl2 = this.ignoreCaseCheck.isSelected();
        TextSearch.Matcher matcher = new TextSearch.Matcher(string, bl, bl2);
        matcher.setBackward(this.searchBackward);
        matcher.setContinuously(true);
        for (TextSearch object : this.targets) {
            object.reset();
        }
        boolean bl3 = this.currentTarget.search(matcher);
        if (!bl3) {
            void var6_10;
            if (this.currentTarget instanceof Component) {
                Container container = ((Component)((Object)this.currentTarget)).getParent();
            } else {
                Container container = this.getParent();
            }
            JOptionPane.showMessageDialog((Component)var6_10, res.get("message.notfound", string), null, 2);
        }
    }

    static enum ActionKey {
        close,
        search,
        forward,
        backward;

    }
}

