/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Font;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;

final class FontControlLookAndFeel
extends BasicLookAndFeel {
    private static final LookAndFeel BASE = UIManager.getLookAndFeel();
    private final String fontFamily;
    private final int fontStyleMask;
    private final double sizeRate;

    FontControlLookAndFeel(String string, int n, double d) {
        this.fontFamily = string;
        this.fontStyleMask = n;
        this.sizeRate = d;
    }

    static void change(String string, int n, double d) {
        try {
            UIManager.setLookAndFeel(new FontControlLookAndFeel(string, n, d));
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            throw new IllegalStateException(unsupportedLookAndFeelException.toString());
        }
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = BASE.getDefaults();
        for (Map.Entry entry : uIDefaults.entrySet()) {
            Object v;
            Object k = entry.getKey();
            if (!String.valueOf(k).endsWith("font") || !((v = entry.getValue()) instanceof UIDefaults.ActiveValue)) continue;
            entry.setValue(new FontControlActiveValue((UIDefaults.ActiveValue)v, this.fontFamily, this.fontStyleMask, this.sizeRate));
        }
        return uIDefaults;
    }

    @Override
    public String getDescription() {
        return BASE.getDescription();
    }

    @Override
    public String getID() {
        return BASE.getID();
    }

    @Override
    public String getName() {
        return BASE.getName();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return BASE.isNativeLookAndFeel();
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return BASE.isSupportedLookAndFeel();
    }

    private static final class FontControlActiveValue
    implements UIDefaults.ActiveValue {
        private final UIDefaults.ActiveValue base;
        private final String fontFamily;
        private final int fontStyleMask;
        private final double sizeRate;

        FontControlActiveValue(UIDefaults.ActiveValue activeValue, String string, int n, double d) {
            this.base = activeValue;
            this.fontFamily = string;
            this.fontStyleMask = n;
            this.sizeRate = d;
        }

        @Override
        public Object createValue(UIDefaults uIDefaults) {
            Object object = this.base.createValue(uIDefaults);
            if (object instanceof Font) {
                Font font = (Font)object;
                int n = font.getStyle() & this.fontStyleMask;
                int n2 = (int)((double)font.getSize() * this.sizeRate);
                return new FontUIResource(this.fontFamily, n, n2);
            }
            return object;
        }
    }
}

