/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Environment;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ConnectorEditDialog;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.FlexiblePanel;

final class ConnectorMapEditDialog
extends JDialog
implements ChangeListener,
AnyActionListener {
    private static final ResourceManager res = ResourceManager.getInstance(ConnectorMapEditDialog.class);
    private final ConnectorMap connectorMap;
    private final JList idList;
    private final DefaultListModel listModel;

    ConnectorMapEditDialog(JFrame jFrame, Environment environment) {
        super(jFrame);
        DefaultListModel<ConnectorEntry> defaultListModel = new DefaultListModel<ConnectorEntry>();
        this.connectorMap = new ConnectorMap(environment.getConnectorMap());
        this.idList = new JList(defaultListModel);
        this.listModel = defaultListModel;
        this.setTitle(res.get("title", new Object[0]));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        FlexiblePanel flexiblePanel = new FlexiblePanel();
        flexiblePanel.c.anchor = 10;
        flexiblePanel.c.insets = new Insets(8, 12, 8, 0);
        this.add(flexiblePanel);
        JList jList = this.idList;
        jList.setSelectionMode(0);
        for (ConnectorEntry object2 : ConnectorEntry.toList(this.connectorMap.values())) {
            defaultListModel.addElement(object2);
        }
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setWheelScrollingEnabled(true);
        jList.addMouseListener(new IdListMouseListener());
        flexiblePanel.addComponent(jScrollPane, false);
        JPanel jPanel = new JPanel(new GridLayout(6, 1, 4, 2));
        jPanel.add(this.createJButton((Object)ActionKey.addNew));
        jPanel.add(this.createJButton((Object)ActionKey.modify));
        jPanel.add(this.createJButton((Object)ActionKey.rename));
        jPanel.add(this.createJButton((Object)ActionKey.remove));
        jPanel.add(this.createJButton((Object)ActionKey.up));
        jPanel.add(this.createJButton((Object)ActionKey.down));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.insets = new Insets(8, 32, 8, 32);
        flexiblePanel.addComponent(jPanel, true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 16, 8));
        jPanel2.add(this.createJButton((Object)ActionKey.submit));
        jPanel2.add(this.createJButton((Object)ActionKey.cancel));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.fill = 0;
        flexiblePanel.addComponent(jPanel2, false);
        AnyAction anyAction = new AnyAction(this.rootPane);
        anyAction.bind((AnyActionListener)this, true, (Object)ActionKey.cancel, KeyStroke.getKeyStroke(27, 0));
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.anyActionPerformed(new AnyActionEvent((Object)this, (Object)ActionKey.cancel, new Object[0]));
        }
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        if (anyActionEvent.isAnyOf(new Object[]{ActionKey.addNew})) {
            String string = JOptionPane.showInputDialog(this, (Object)res.get("i.input-new-connector-id", new Object[0]));
            if (string == null) {
                return;
            }
            if (this.connectorMap.containsKey(string)) {
                String string2 = res.get("e.id-already-exists", string);
                JOptionPane.showMessageDialog(this, string2, null, 0);
            } else {
                Connector connector;
                try {
                    connector = new Connector(string, new Properties());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), null, 0);
                    return;
                }
                this.openConnectorEditDialog(connector);
            }
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.modify})) {
            ConnectorEntry connectorEntry = (ConnectorEntry)this.idList.getSelectedValue();
            if (connectorEntry != null) {
                this.openConnectorEditDialog(connectorEntry.getConnector());
            }
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.rename})) {
            Connector connector;
            Object e = this.idList.getSelectedValue();
            if (e == null) {
                return;
            }
            ConnectorEntry connectorEntry = (ConnectorEntry)e;
            String string = JOptionPane.showInputDialog(this, res.get("i.input-new-connector-id", new Object[0]), connectorEntry.getId());
            if (string == null || string.equals(connectorEntry.getId())) {
                return;
            }
            this.connectorMap.remove(connectorEntry);
            this.connectorMap.put(string, connectorEntry.getConnector());
            DefaultListModel defaultListModel = (DefaultListModel)this.idList.getModel();
            try {
                connector = new Connector(string, connectorEntry.getConnector());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), null, 0);
                return;
            }
            defaultListModel.set(defaultListModel.indexOf(connectorEntry), new ConnectorEntry(string, connector));
            this.idList.repaint();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.remove})) {
            if (JOptionPane.showConfirmDialog(this, res.get("i.confirm-remove", new Object[0]), "", 2) != 0) {
                return;
            }
            ConnectorEntry connectorEntry = (ConnectorEntry)this.idList.getSelectedValue();
            this.connectorMap.remove(connectorEntry.getId());
            DefaultListModel defaultListModel = (DefaultListModel)this.idList.getModel();
            defaultListModel.removeElement(connectorEntry);
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.up})) {
            this.shiftSelectedElementUpward();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.down})) {
            this.shiftSelectedElementDownward();
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.submit})) {
            this.requestClose(true);
        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.cancel})) {
            this.requestClose(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Connector) {
            Connector connector = (Connector)object;
            String string = connector.getId();
            this.connectorMap.setConnector(string, connector);
            ConnectorEntry connectorEntry = new ConnectorEntry(string, connector);
            int n = this.listModel.indexOf(connectorEntry);
            if (n >= 0) {
                this.listModel.set(n, connectorEntry);
                this.idList.setSelectedIndex(n);
            } else {
                this.listModel.add(0, connectorEntry);
                this.idList.setSelectedIndex(0);
            }
        }
    }

    private JButton createJButton(Object object) {
        String string = String.valueOf(object);
        JButton jButton = new JButton(res.get("button." + string, new Object[0]));
        jButton.setActionCommand(string);
        jButton.addActionListener(new AnyAction(this));
        return jButton;
    }

    private void openConnectorEditDialog(Connector connector) {
        ConnectorEditDialog connectorEditDialog = new ConnectorEditDialog(this, connector);
        connectorEditDialog.addChangeListener(this);
        connectorEditDialog.setModal(true);
        connectorEditDialog.setLocationRelativeTo(this.getParent());
        connectorEditDialog.setSize(connectorEditDialog.getPreferredSize());
        connectorEditDialog.setVisible(true);
    }

    private void shiftSelectedElementUpward() {
        int n = this.idList.getSelectedIndex();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        ConnectorMapEditDialog.swap(this.listModel, n, n2);
        this.idList.setSelectedIndex(n2);
        this.idList.ensureIndexIsVisible(n2);
    }

    private void shiftSelectedElementDownward() {
        int n;
        int n2 = this.idList.getSelectedIndex();
        if (n2 == (n = this.listModel.getSize()) - 1) {
            return;
        }
        int n3 = n2 + 1;
        ConnectorMapEditDialog.swap(this.listModel, n2, n3);
        this.idList.setSelectedIndex(n3);
        this.idList.ensureIndexIsVisible(n3);
    }

    private static void swap(DefaultListModel defaultListModel, int n, int n2) {
        Object e = defaultListModel.get(n);
        defaultListModel.set(n, defaultListModel.get(n2));
        defaultListModel.set(n2, e);
    }

    private void requestClose(boolean bl) {
        if (bl) {
            if (JOptionPane.showConfirmDialog(this, res.get("i.confirm-save", new Object[0]), "", 0) != 0) {
                return;
            }
            ConnectorMap connectorMap = new ConnectorMap();
            for (Object object : this.listModel.toArray()) {
                ConnectorEntry connectorEntry = (ConnectorEntry)object;
                String string = connectorEntry.getId();
                connectorMap.setConnector(string, this.connectorMap.getConnector(string));
            }
            try {
                ConnectorConfiguration.save(connectorMap);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.connectorMap.clear();
            this.connectorMap.putAll(connectorMap);
        } else {
            ConnectorMap connectorMap;
            try {
                connectorMap = ConnectorConfiguration.load();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (!this.connectorMap.equals(connectorMap) && JOptionPane.showConfirmDialog(this, res.get("i.confirm-without-save", new Object[0]), "", 2) != 0) {
                return;
            }
        }
        this.dispose();
    }

    private final class IdListMouseListener
    extends MouseAdapter {
        private IdListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() % 2 == 0) {
                ConnectorEntry connectorEntry = (ConnectorEntry)ConnectorMapEditDialog.this.idList.getSelectedValue();
                ConnectorMapEditDialog.this.openConnectorEditDialog(connectorEntry.getConnector());
            }
        }
    }

    static enum ActionKey {
        addNew,
        modify,
        rename,
        remove,
        up,
        down,
        submit,
        cancel;

    }
}

