% Stew4 ユーザーマニュアル
%
% version 4.0


## Stewとは何ですか？

Stewは、JDBCを使った小規模なデータベースフロントエンドです。
コマンドラインのようなインターフェイスを持っていて、SQLを入力して実行したりできます。
ちょっとした処理であれば、バッチのように使用することもできます。

概要については、README_ja.mdをご覧ください。



## 使用上の注意


### パスワードの保存方式

パスワードは、デフォルトではそのまま保存します。
生のパスワードを保存したくない場合は、暗号化を利用できます。

詳しくは、[使い方-接続設定](#接続設定)を参照してください。


### コネクション切断時はrollbackしない

デフォルトでは、disconnectコマンドによりコネクションを切断するとき、rollbackを発行しません。
DBMSによっては、トランザクションが自動的にコミットされてしまうことがありますので注意が必要です。

「切断時に自動ロールバック」を設定すると、disconnectの際に自動的にrollbackを発行します。
詳細は、[使い方-接続設定](#接続設定)を参照してください。


### その他

プロジェクトサイトにて追加説明を行っていますので、あわせてご利用ください。

<http://stew.sourceforge.jp/>  
<http://argius.net/wiki/index.php?Stew%20tutorial> (argius.net)



## インストール

Java実行環境バージョン6(JRE6)以上がインストールされている必要があります。
また、利用するデータベースのJDBCドライバが必要です。

リリースパッケージ(通常はzipファイル)を任意のディレクトリに展開します。

インストールサイズを最小限にしたい場合は、
リリースパッケージに含まれている"stew.jar"だけを展開してください。

起動コマンドの設定は、次の起動方法を参照してください。



## 起動方法

GUIモードで起動する場合は、以下のコマンドを実行します。

    > java -jar stew.jar --gui

CUIモードで起動する場合は、以下のコマンドを実行します。

    > java -jar stew.jar --cui


起動スクリプトもしくはショートカットやエイリアスを作成しておくと便利です。
stew.propertiesに以下の設定を追加すれば、JarファイルのダブルクリックでGUI起動できるようになります。

    stew.boot=GUI


Stewを実行すると、システムディレクトリ".stew"が作成され、設定の保存に使用されます。
".stew"ディレクトリは、デフォルトではカレントディレクトリに作成されます。



## アンインストール

インストールしたファイルと".stew"ディレクトリを削除してください。


----------------------------------------------------------------------------------------------------

## 使い方

Stewを使用するには、JDBC接続が可能なデータベースと、JDBCドライバが必要です。
JDBCドライバ自体の詳細については、各データベースの説明書などを参照してください。


### 接続設定

CUIの場合は、起動時に--editオプションを指定、またはコマンドとして--editを実行すると、
編集プログラムが起動します。

GUIの場合は、メニューの"接続設定"を実行すると、編集ダイアログが開きます。


それぞれの設定項目の説明は次のとおりです。

コネクタID
:   connectコマンドなどに渡すIDです。英数字のみ指定できます。

コネクタ名
:   プロンプトに表示される接続名です。文字制限は特にありません。

クラスパス
:   JDBCドライバのクラスパスを指定します。Javaの-CLASSPATHオプションと同じ形式で指定します。

ドライバ
:   JDBCドライバのDriver実装クラスを指定します。GUIの場合、クラスパスが指定されていれば、
    "ドライバの検索"から選択できます。

接続先URL
:   JDBCのURL(DriverManager.getConnection(url)に指定するurlと同じもの)を指定します。

ユーザ
:   JDBCのURLと同時に指定するユーザIDを指定します。

パスワード
:   ユーザIDのパスワードを指定します。

暗号化処理
:   パスワードの保存方法を選択します。次項"パスワードの保存について"を参照してください。

読取専用
:   コネクションをREADONLYに設定し、更新の有るコマンドを実行できないようにします。
    （コマンド側のReadOnlyに拠る。）

自動ロールバック
:   設定すると、切断時に自動でロールバックします。

これらの情報は、".stew/connectors.properties"に保存されます。
手動で編集することもできますが、その際は注意して行ってください。


### パスワードの保存について

パスワードは設定ファイルに保存されるため、そのまま保存すると都合が悪い場合があります。

パスワードの保存方法は、暗号化処理を選択することができます。

PlainTextPassword
:   （デフォルト）パスワードをそのまま保存します。

PbePassword
:   PBE暗号を使用してパスワードを保存します。
    [メニュー-暗号鍵の入力](#コマンドc---暗号鍵の入力k)で暗号鍵を入力した後、
    接続設定でパスワードを入力して保存すると、暗号化された状態で保存します。
    次回起動時、再度暗号鍵を入力するまで、パスワードが復号できなくなります。

独自のパスワード暗号化を追加することもできます。
（実装詳細：Passwordインタフェースの実装クラスを追加します。）


### 無名接続

接続設定なしで接続を行うことができます。
ドライバが特定できるようになっている必要があります。（次の段落で説明）

    > connect <user>/<password>@<URL>
    
    (例)
    > connect user/password1@jdbc:firebirdsql://127.0.0.1//home/argius/test.fdb

最も簡単な方法は、ドライバファイルを起動ディレクトリに置くだけです。
ドライバ名が指定されていない場合は、このファイルの中を探索してドライバ名を特定します。
但し、この探索は時間がかかるので、時間を節約するには"jdbc.drivers"システムプロパティを
指定してください。


### 対話モード

通常の起動では、対話モードでの操作となります。
対話モードでは、コマンド入力待ち状態になった時にコマンドを入力し、
処理が終わると再びコマンド入力待ちになります。


### 一行完結モード(One-Liner)

Stewの処理が一行の入力で完結します。
"stew"コマンドを設定していると仮定すると、次のような形式で実行します。

    > stew <connector-id> <command>

実行すると、<connector-id>の接続設定で接続を開始し、その接続を使用してコマンドを実行します。
コマンド実行後、接続を切断して終了します。

このモードでは、ご利用のshell環境の制約（例えば、ワイルドカード,リダイレクト など）を
受けますのでご注意ください。


### エイリアス(alias)

長いコマンドに別名(alias)をつけて、短縮コマンドとして利用できます。
詳しくは、コマンド[alias](#alias - エイリアス(コマンド別名)の登録 (組み込みコマンド)),
[unalias](#unalias - エイリアス(コマンド別名)の解除 (組み込みコマンド))を参照してください。


----------------------------------------------------------------------------------------------------

## コマンド(Stew内部コマンド)

組み込みコマンドは、Stewから切り離すことができないコマンドです。
それ以外は、追加コマンドとして実装されています。
（実装詳細：追加コマンドはCommandクラスのサブクラスによる実装ですが、
  組み込みコマンドはCommand.invokeメソッドに直接書かれている処理です。）

コマンドでない文が指定された場合は、SQLとして実行されます。
バインド変数のあるSQL文を使う場合は、最後に";"(セミコロン)をつけ、
それ以降にカンマ区切りでパラメータを指定できます。
この機能は、一部のコマンドでも利用できます。

組み込みコマンドのうち、connect/-e/-f/alias/unalias/exitは接続時以外でも使用できます。


### connect - データベースに接続する (組み込みコマンド)

    > connect <connector-id>
    > -c <connector-id>

予め用意した接続設定を使用して、データベースに接続します。

対話モードでは、disconnectまたは強制的に切断されるまで、接続が維持されます。
すでに接続中の場合は、その接続を切断してから接続を行います。


### disconnect - データベースとの接続を切断する (組み込みコマンド)

    > disconnect
    > -d

データベースとの接続を切断します。

接続設定でrollbackを指定している場合は、rollbackを試みます。


### commit - トランザクションのコミット (組み込みコマンド)

現在のトランザクションでの変更をコミットします。

**コミットする際は、誤って必要なデータを削除しないよう注意してください。**


### rollback - トランザクションのロールバック (組み込みコマンド)

現在のトランザクションでの変更をロールバックします。


### -e - 複数コマンドの評価 (組み込みコマンド)

    > -e <コマンド> -e <コマンド> ...

コマンドを連続して実行させます。
exportなどを同時に実行する場合や、コマンドラインからの実行の場合に使います。


### -f - ファイル内容をコマンドとして実行 (組み込みコマンド)

    > -f <ファイル>

ファイルの内容をコマンドとして実行します。
再帰的に指定できますが、無限ループは検知できないので注意してください。


### -s - ファイル内容をスクリプトとして実行 (組み込みコマンド)

    > -s <ファイル>

ファイルの内容をスクリプト(JavaScript)として実行します。

スクリプト内では、以下の変数が定義済みになります。

 * 接続中のコネクション: connection, conn
 * パラメーター: parameter, p
 * 出力制御: outputProcessor, op


### cd - カレントディレクトリの移動 (組み込みコマンド)

    > cd <ディレクトリ>

カレントディレクトリを指定したディレクトリに移動します。
（このカレントディレクトリはStew内部で管理するものです。）


### @ - 場所の表示 (組み込みコマンド)

    > @

カレントディレクトリとシステムディレクトリの場所を表示します。


### ? - システムプロパティ (組み込みコマンド)

    > ? [<プロパティ名> [<プロパティ名2> ... <プロパティ名n>]]

指定されたシステムプロパティを表示します。(System.getProperty)

引数を指定しない場合は、JRE,OS,Localeの情報を表示します。

    > ?
    JRE : ...
    OS : ...
    Locale : ja_JP
    > ? java.version user.timezone zzz
    java.version=[1.6.0_##]
    user.timezone=[Asia/Tokyo]
    zzz=undefined


### alias - エイリアス(コマンド別名)の登録 (組み込みコマンド)

    > alias [<エイリアス> [<コマンド>]]

コマンド別名を登録します。
引数が1つで実行した場合は、既に設定されたコマンド内容を表示します。
引数なしで実行した場合は、すべての定義済みエイリアスを表示します。

登録または表示の前にファイルからメモリ上の情報を最新化します。
ファイルを直接修正したり、他のスレッドで変更した内容を反映させたい場合は、
このコマンドを実行してください。
（実装詳細：循環参照などの無限ループ抑制のために、展開の深さは最大100。）

    > alias
    エイリアスは未定義です。
    > alias search select * from
    > alias count select count(*) from
    > alias search
    alias search=[select * from]
    > search table1
    >> select * from table1
    (select * from table1 の結果)
    >


### unalias - エイリアス(コマンド別名)の解除 (組み込みコマンド)

    > unalias <エイリアス>

コマンド別名を解除します。解除する対象がない場合は何もしません。
解除対象の有無にかかわらず、ファイルからメモリ上の情報を最新化します。


### exit - 終了 (組み込みコマンド)

    > exit

Stewを終了します。確認待ちは行いません。

接続中の全てのコネクションは自動的に切断されます。
ロールバックは、自動ロールバックを設定しているコネクタのみ行われます。
自動ロールバックについては、[使い方-接続設定](#接続設定)を参照してください。


### load - ファイルから実行

    > load [<SQLファイル> | <データファイル> <テーブル名> [ HEADER ]]

指定されたファイルを読み込んで、ＳＱＬを実行します。

パラメータが1個の場合は、ファイルをSQL文と見なして実行します。

パラメータが2個以上の場合は、ファイルをデータファイルと見なして、インポートを実行します。
ファイルの拡張子によって、ファイル形式が自動的に選択されます。
（実装詳細：基本的にはimportと同じ動作ですが、バッチ実行ではなく1件ずつ処理されます。）

 *. .csv : CSV形式
 *. .xml : XML形式（定義：src/net/argius/stew/io/stew-table.dtd）
 *. 上記以外 : TAB区切りテキスト形式


### import - ファイルのインポート

    > import [<データファイル> <テーブル名> [ HEADER ]]

ファイルをデータファイルと見なして、インポートを実行します。
ファイルの拡張子によって、ファイル形式が自動的に選択されます。
（実装詳細：基本的には、loadのパラメータ2個以上指定した時と同じ動作ですが、
  Statement.addBatch()を使用します。）

 * .csv : CSV形式
 * .xml : XML形式（定義：src/net/argius/stew/io/stew-table.dtd）
 * 上記以外 : TAB区切りテキスト形式

一括で処理する件数を[#property.Import.batch.limit:プロパティ]で設定することができます。


### export - 検索結果のエクスポート

    > export <ファイル> [ HEADER ] [command(select|find|report)]

指定したファイルに、コマンドの検索結果を出力します。
ファイルの拡張子によって、ファイル形式が自動的に選択されます。

 * .htm,.html : HTML形式
 * .csv : CSV形式
 * .xml : XML形式（定義：src/net/argius/stew/io/stew-table.dtd）
 * 上記以外 : TAB区切りテキスト形式


### time - 実行時間計測

    > time [<回数>] <SQL文>

指定したSQL文を実行し、その実行時間を計測して表示します。

回数が指定された場合は、回数分SQLを繰り返し実行して、
「合計」「平均」「最大」「最小」を集計します。
回数を指定しない場合は、1回の実行時間を表示します。

    > time select * from EMPLOYEE
    実行時間 : 0.093 秒
    > time 100 select * from EMPLOYEE
    合計 : 0.484 秒
    平均 : 0.005 秒
    最大 : 0.094 秒
    最小 : 0.000 秒
    >


### find - テーブル名検索

    > find <テーブル名パターン> [<テーブル種別パターン> [<スキーマ名パターン> [<カタログ名パターン> [ FULL ]]]]

参照可能なテーブルの一覧を表示します。
"パターン"というキーワードを含むパラメータは、ワイルドカード（#,?）が指定できます。


### report - データベース情報表示

    > report - | <テーブル名> [ FULL | PK | INDEX ]

接続中のコネクションに関する情報を表示します。

-（ハイフン）が指定された場合は、ＤＢとJDBCドライバの名称とバージョン、
接続ユーザとアドレスを表示します。

テーブル名のみが指定された場合は、テーブルの列情報が表示されます。

テーブル名とオプションが指定された場合は、PKを指定するとプライマリキーの一覧が、
INDEXを指定するとインデックスキーの一覧が、それぞれ表示されます。
FULLを指定すると、API(DatabaseMetaData#getColumns)が返すすべての列が表示されます。


### download - 1データごとにダウンロード

    > download <ルートディレクトリ> SELECT <ダウンロードするデータの列> [, ファイルパス...] FROM ...

1つの列のデータをダウンロードしてファイルに保存します。

どのデータ型でも利用できます。
長めのテキスト項目やラージオブジェクト(BLOB,CLOB)を一挙にファイルに保存する場合などに有用です。

ファイルは、複数ファイルをダウンロードできるようにするため、
データからファイル名を生成できるようになっています。

ファイル名は、2列目以降の列を文字列として結合したものとなります。
これはプライマリキーと拡張子を指定することを想定しています。

    > download emp select FULL_NAME, JOB_COUNTRY, '/', EMP_NO, '.txt' from EMPLOYEE
    ディレクトリ[./emp/USA]を作成しました。
    ダウンロードされました。 (0.014 Kbytes, file=[./emp/USA/2.txt])
    ダウンロードされました。 (0.012 Kbytes, file=[./emp/USA/4.txt])
     ・
     ・
     ・
    ダウンロードされました。 (0.012 Kbytes, file=[./emp/USA/24.txt])
    ディレクトリ[./emp/England]を作成しました。
    ダウンロードされました。 (0.011 Kbytes, file=[./emp/England/28.txt])
     ・
     ・
     ・
    ダウンロードされました。 (0.018 Kbytes, file=[./emp/USA/145.txt])
    42 件 ヒットしました。

データが1件の場合は、データ列のみ指定すれば、
ファイルパスの前半部分がそのままファイル名となります。

同名のファイルが存在したり、ディレクトリ作成時に権限が無い場合はエラーとなり、
その時点で処理を中断します。


### upload - ファイル内容を1データとして登録

    > upload <ファイルパス> <INSERT文 or UPDATE文>

SQLのプレースホルダで指定された列にファイル内容を登録します。


### wait - 待機

    > wait 秒(小数第3位まで指定可)

指定された秒数、待機します。

連続したコマンドを実行する場合などに使えるかもしれません。



## GUIモード・メニュー

GUIモードのメニューについての説明です。


### ファイル(F) - 新しいウィンドウ(N) Ctrl-N

新しいウィンドウを開きます。

新しいウィンドウは、元のウィンドウとは独立した接続で処理が行われます。


### ファイル(F) - 閉じる(C) Ctrl-W

ウィンドウを閉じます。
コネクションが接続中の場合は、確認ダイアログを表示します。

開いているウィンドウが1つの場合は、終了(X)と同じ動作となります。


### ファイル(F) - 終了(X) Ctrl-Q

アプリケーションを終了します。
確認ダイアログが表示され、"はい"を選択すると終了します。


### 編集(E) - 切り取り(T) Ctrl-X

選択範囲をクリップボードにコピーして、選択された部分を削除します。
（基本的に、一般的なアプリケーションと同じ処理です。）


### 編集(E) - コピー(C) Ctrl-C

選択範囲をクリップボードにコピーします。
（基本的に、一般的なアプリケーションと同じ処理です。）


### 編集(E) - 貼り付け(P) Ctrl-V

カーソル位置にクリップボードの内容を貼り付けます。
（基本的に、一般的なアプリケーションと同じ処理です。）


### 編集(E) - すべて選択(A) Ctrl-A

選択している領域（テーブルまたは入出力欄）を全選択状態にします。


### 編集(E) - 検索(F) Ctrl-F

選択している領域（テーブル、テーブル列名、入出力欄、情報ツリー）内の文字列を検索します。

テーブル、テーブル列名はセル単位で検索します。
入出力欄は、一致部分をハイライトします。
情報ツリーは、選択しているノードと同じ深さのノードとそれらのサブノード単位で検索します。

オプションで、「正規表現を使用する」「大文字と小文字を区別しない」が指定できます。


### 編集(E) - フォーカス切替(G) Ctrl-G

検索結果エリアと入力欄のフォーカスを入れ替えます(toggle)。


### 編集(E) - メッセージのクリア

入出力欄のメッセージをクリアします。


### 表示(V) - ステータス バー(B)

選択された場合、ウィンドウの下部にステータスバーを表示します。

設定は保存されます。


### 表示(V) - 列番号を表示(C)

選択された場合、検索結果の列名に番号を付けます。


### 表示(V) - 情報ツリーペインを表示(I)

選択された場合、データベース情報ツリーペインを表示します。


### 表示(V) - 常に手前に表示(T)

選択された場合、ウィンドウを常に手前に表示するようにします。


### 表示(V) - 最新状態に更新(R) F5

検索結果を表示した際のクエリを再発行して、最新状態を表示します。


### 表示(V) - 列幅を拡大(W) Ctrl-.(period)

検索結果の列幅をそれぞれ1.5倍に拡大します。


### 表示(V) - 列幅を縮小(N) Ctrl-,(comma)

検索結果の列幅をそれぞれ2/3に縮小します。


### 表示(V) - 列幅を調整(A) Ctrl-/(slash)

検索結果の列幅を自動調整します。次項の「列幅自動調整」で選択されたモードで調整されます。


### 表示(V) - 列幅自動調整(M)

検索結果表示時に、検索結果の列幅を自動調整するモードを選択します。

 * なし(N) : 自動調整を行いません。
 * ヘッダ基準(H) : ヘッダ名のサイズを基準に、各列幅を自動調整します。
 * 値基準(V) : 列の中で最も長い値のサイズを基準に、各列幅を自動調整します。
 * ヘッダと値基準(A) : ヘッダを含めて、列の中で最も長い値のサイズを基準に、各列幅を自動調整します。


### コマンド(C) - 実行(X) Ctrl-M

コマンドを実行します。入出力欄でエンターキーを押したのと同じ効果があります。


### コマンド(C) - 中断(B) Ctrl-Pause(Break)

コマンドを中断します。サーバ側の処理はキャンセルされません。


### コマンド(C) - 前のコマンド履歴(P) Ctrl-↑

コマンド履歴を1つ遡ります。


### コマンド(C) - 次のコマンド履歴(N) Ctrl-↓

コマンド履歴を1つ進みます。


### コマンド(C) - ロールバック(R)

確認ダイアログを表示し、OKを押すとロールバックを実行します。


### コマンド(C) - コミット(M)

確認ダイアログを表示し、OKを押すとコミットを実行します。


### コマンド(C) - 接続(C) Ctrl-E

接続リストを表示します。
接続リストで接続したい接続IDを選択して"了解"を押すと、connectと同じ処理が実行されます。


### コマンド(C) - 切断(D) Ctrl-D

接続を切断します。disconnectコマンドと同じです。


### コマンド(C) - 終了処理(0)

コマンドが終了した時、そのウィンドウが非アクティブの場合に
通知のために発生させるアクションを設定します。

 * なし(N) : 何もしません。
 * フォーカス(F) : ウィンドウをフォーカス状態にします。
   ただし、同じプロセス内のほかのウィンドウがアクティブの場合に限ります。
   他のプロセスがアクティブの場合はフォーカスされません。
 * 振動(S) : ウィンドウを振動させます。
 * 点滅(B) : ウィンドウ内を点滅（緑色）させます。


### コマンド(C) - 暗号鍵の入力(K)

起動中のプロセスで接続設定のパスワード暗号化に使用される秘密鍵を入力します。


### コマンド(C) - 接続設定(E)

接続設定ダイアログを表示します。


### データ(D) - 並び替え(S) Alt-S

検索結果をファイルに出力します。
検索結果が表示されている場合のみ有効です。


### データ(D) - インポート(I)

検索結果のテーブルにファイルをインポートします。
importコマンドとは独立した処理です。検索結果が表示されている場合のみ有効です。


### データ(D) - エクスポート(E) Ctrl-Shift-S

検索結果をファイルに出力します。
exportコマンドとは独立した処理です。検索結果が表示されている場合のみ有効です。


### ヘルプ(H) - ヘルプを表示(H)

ヘルプ(このファイル)をデフォルトブラウザで表示します。

環境によっては表示できない場合があります。


### ヘルプ(H) - Stew について(A)

バージョン情報ダイアログを表示します。



## GUIモード・その他


### 全体

テキスト入力欄は共通して、
「元に戻す」「やり直す」「切り取り」「コピー」「貼り付け」「すべて選択」の
ショートカットが利用できます。

これらは、コンテキストメニューからも操作できます。


### 結果テーブル

検索コマンドを実行したときに、結果を表示します。
最左列は行番号が表示されます。列幅自動調整が設定されていれば、列幅が自動的に調整されます。

セルを編集すると、テーブルに反映(UPDATE)されます。
行番号が"+"になっている行は「非リンク行」です。
非リンク行については、コンテキストメニューを参照。


### 入出力欄

コマンドの入力とメッセージの出力が同居する、コマンドラインのようなインターフェイスです。

エンターキーを押すと、プロンプトから末尾までがコマンドとして解釈され実行されます。
カーソルが末尾にない場合は、カーソルが末尾に移動します。
プロンプトより前の部分は編集不可となっています。

デスクトップからファイルをドロップすると、
「パスの貼り付け」「内容の貼り付け」のいずれかが実行できます。


### ステータスバー

直前のコマンドとその実行時間が表示されます。
実行時間は、timeコマンドとは異なり、コマンドの開始から終了までの所要時間となります。


### コンテキストメニュー

マウスの右クリックにより、そのコントロールに即した機能のメニューが表示されます。
表示されるメニュー内容は、入力部分ごとに異なります。

メニューは以下のとおりです。

この列を並べ替え
:   右クリックした列（選択されている列では無く）をソートします。
    同じ列を続けてソートすると、逆順でソートします。

コピー
:   選択しているセルを、タブ区切りテキスト形式でクリップボードに送ります。
    タブ文字や改行文字をエスケープしません。

エスケープ付でコピー
:   選択しているセルを、エスケープ付のタブ区切りテキスト形式でクリップボードに送ります。
    値に改行文字が含まれている場合でも、直接スプレッドシートなどに貼り付けることができます。

貼り付け
:   選択したセルに、クリップボードのデータを貼り付けます(UPDATE)。
    選択範囲外のデータは無視されます。
    データより選択範囲が大きい場合でも、貼り付けは繰返されません。

すべて選択
:   すべてのセルを選択状態にします。

セルの値をクリア
:   データ型にかかわらず、選択したセルにNullを設定します(UPDATE)。

現在時刻の貼り付け
:   選択したセルに現在時刻を設定します(UPDATE)。

列名をコピー
:   現在表示しているヘッダの値を、タブ区切りテキスト形式でクリップボードに送ります。

列名を検索
:   現在表示しているヘッダの文字列から列名を検索します。

新しい行を追加
:   表の最後に新しい行を追加します。
    この時点では、データベースへの反映は行われません（非リンク行）。
    値を入力した後で「行をデータベースへリンク」を実行すると、データベースへ反映されます。

クリップボードのデータを追加
:   クリップボードのタブ区切りテキストを、データベースに連続して追加します(INSERT)。
    エラーの場合は、非リンク行となります。
    中断は強制終了以外できませんので、データ量が多い場合はimportコマンドを推奨します。

行を複製
:   表の最後に選択した行のコピーを追加します。
    この時点では、データベースへの反映は行われません（非リンク行）。
    値を入力した後で「行をデータベースへリンク」を実行すると、データベースへ反映されます。

行をデータベースへリンク
:   非リンク行をデータベースへ反映します(INSERT)。

行を削除
:   選択行を削除するのと同時にデータベース上のテーブルから削除します(DELETE)。
    （非リンク行の場合はDELETEは実行されません。）
    複数行を選択していても実行できます。

※COMMIT,ROLLBACKは手動です。


### データベース情報ツリー

データベースのテーブルなどの情報をツリー表示します。

簡易SQL文自動生成機能が利用できます。


コピー
:   ノードの文字列表現をコピーします。

単純名をコピー
:   ノードを表す単純な名称をコピーします。

完全名をコピー
:   カタログ名、スキーマ名を完全修飾した名称をコピーします。

最新状態に更新
:   選択したノードの情報を再読み込みして最新状態に更新します。

WHERE句条件部を生成
:   選択した列の情報からWHERE句より後の部分を生成します。

SELECT句を生成(WHERE付)
:   選択したテーブルと列の情報からSELECT文を生成します。
    末尾にWHEREキーワードが付きます。

UPDATE文を生成(WHERE付)
:   選択したテーブルと列の情報からUPDATE文を生成します。
    末尾にWHEREキーワードが付きます。
    テーブルは1つだけ選択できます。

INSERT文を生成
:   選択したテーブルと列の情報からINSERT文を生成します。
    テーブルは1つだけ選択できます。

この列名の列にジャンプ
:   結果セットに同じ列名がある場合はその列にジャンプします。
    ダブルクリックでも同じ効果があります。

列番号を表示/非表示
:   列ノードの番号表示/非表示を切り替えます。 


接続したときに自動で指定したノードを展開する機能があります（実験的機能）。

システムディレクトリに"autoexpansion.tsv"という名前でファイルを作成します。
内容は、展開したいノードのリストを1行毎にTSV形式で記載します。
実際にツリーに表示されるノード文字列をTABでつないだものになります。

    # 例: コネクタ"H2 DB1"(IDでなく接続名)のCATALOG1.PUBLIC.TABLE1を展開する
    H2 DB1(TAB)CATALOG1(TAB)PUBLIC(TAB)TABLE(TAB)TABLE1


### 設定保存

以下の設定が、ウィンドウを閉じたとき(終了したときではない)に保存され、
次回以降のウィンドウの設定として使用されます。

 * ウィンドウ位置
 * ウィンドウサイズ
 * 分割バー位置
 * ステータスバー(表示/非表示)
 * 列番号(表示/非表示)
 * 情報ツリーペイン(表示/非表示)
 * 常に手前に表示(する/しない)
 * 列幅自動調整モード


### メニューのキー割り当て

システムディレクトリに"keybind.conf"という名前のファイルを作成し、
内容には"メニューのアクション名=KeyStrokeの文字列表現"を設定すると、
メニューのキー割り当てが変更できます。

メニュー以外（コンテキストメニューなど）には適用できません。

    # 例
    # アクション名はsrc/net/argius/stew/ui/window/messages.u8pのMenu.#を参照
    lastHistory = ctrl K



## プロパティ

起動時に値を決定できるパラメータです。

Javaのシステムプロパティ（Javaの-Dオプション）で指定するか、stew.propertiesファイルに記述します。
"設定値"は、設定する値についての説明です。設定値のカッコ内の値は既定値です。
カッコがないものは既定値がありません。


### net.argius.stew.properties - プロパティファイルの場所

設定値：ファイルまたはディレクトリのパス

stew.propertiesファイルを優先的に検索する場所を指定します。

指定されたパスがファイルの場合は、そのファイルをstew.propertiesの代わりに
プロパティファイルとして読み込みます。

指定されたパスがディレクトリの場合は、そこにstew.propertiesがあるものとみなされます。

指定されない場合は、クラスパス、システムディレクトリの順に検索されます。
無い場合はプロパティファイルが無いものとみなされます。


### net.argius.stew.directory - 作業ディレクトリ

設定値：ディレクトリパス(カレントディレクトリ)

コマンドで使用するディレクトリの開始時のパスを指定します。
デフォルトシステムディレクトリとは異なります。


### net.argius.stew.query.timeout - クエリのタイムアウト値

設定値：整数秒(0)

コマンド内のクエリが発行時に設定するタイムアウト値を指定します。
0以下はタイムアウト未指定とみなされます。

（実装詳細：java.sql.Statement#setQueryTimeoutに設定する値。）


### net.argius.stew.rowcount.limit - 出力件数の上限

設定値：上限値(Max＝Integer.MAX_VALUE≒2,147,000,000)

検索結果を出力する上限件数を設定します。exportなどには適用されません。


### net.argius.stew.command.Import.batch.limit - Importのバッチ数の上限値

設定値：上限値(10000)

Importコマンドで一度に実行する件数の上限値を決定します。


### net.argius.stew.ui.window.resident - Windowの常駐

設定値：整数分

**実験的な機能です。**

指定した分ごとに画面の再描画を行い、アプリケーションがスワップアウトしないようにします。


### Loggerの設定

Stew4は標準のLoggingAPIを（ラップして）使用しています。

ログ出力を有効にする場合は、システムプロパティ"java.util.logging.config.file"を設定します。

以下は起動オプションの例。

    -Djava.util.logging.config.file=logging.properties


----------------------------------------------------------------------------------------------------