/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import net.argius.stew.Bootstrap;
import net.argius.stew.CipherPassword;
import net.argius.stew.Command;
import net.argius.stew.DaemonThreadFactory;
import net.argius.stew.Environment;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.Launcher;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionKey;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.ConnectorMapEditDialog;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.ContextMenu;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.FontControlLookAndFeel;
import net.argius.stew.ui.window.Menu;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.TextSearchPanel;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.WindowOutputProcessor;

public final class WindowLauncher
implements Launcher,
AnyActionListener,
Runnable,
Thread.UncaughtExceptionHandler {
    private static final Logger log = Logger.getLogger(WindowLauncher.class);
    private static final ResourceManager res = ResourceManager.getInstance(WindowLauncher.class);
    private static final List<WindowLauncher> instances = Collections.synchronizedList(new ArrayList());
    private final WindowOutputProcessor op;
    private final Menu menu;
    private final JPanel panel1;
    private final JPanel panel2;
    private final JSplitPane split1;
    private final JSplitPane split2;
    private final ResultSetTable resultSetTable;
    private final ConsoleTextArea textArea;
    private final DatabaseInfoTree infoTree;
    private final TextSearchPanel textSearchPanel;
    private final JLabel statusBar;
    private final List<String> historyList;
    private final ExecutorService executorService;
    private Environment env;
    private Map<JComponent, TextSearch> textSearchMap;
    private int historyIndex;
    private JComponent focused;

    WindowLauncher() {
        instances.add(this);
        JSplitPane jSplitPane = new JSplitPane(1);
        DatabaseInfoTree databaseInfoTree = new DatabaseInfoTree(this);
        ResultSetTable resultSetTable = new ResultSetTable(this);
        JTableHeader jTableHeader = resultSetTable.getTableHeader();
        ConsoleTextArea consoleTextArea = new ConsoleTextArea(this);
        this.op = new WindowOutputProcessor(this, resultSetTable, consoleTextArea);
        this.menu = new Menu(this);
        this.panel1 = new JPanel(new BorderLayout());
        this.panel2 = new JPanel(new BorderLayout());
        this.split1 = jSplitPane;
        this.split2 = new JSplitPane(0);
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.infoTree = databaseInfoTree;
        this.textSearchPanel = new TextSearchPanel(this.op);
        this.statusBar = new JLabel(" ");
        this.historyList = new LinkedList<String>();
        this.historyIndex = 0;
        this.executorService = Executors.newScheduledThreadPool(3, DaemonThreadFactory.getInstance());
        this.op.setTitle(res.get(".title", new Object[0]));
        this.op.setIconImage(Utilities.getImageIcon("stew.png").getImage());
        this.op.setDefaultCloseOperation(0);
        jSplitPane.setResizeWeight(0.6f);
        jSplitPane.setDividerSize(4);
        this.split2.setOrientation(0);
        this.split2.setDividerSize(6);
        this.split2.setResizeWeight(0.6f);
        consoleTextArea.setMargin(new Insets(4, 8, 4, 4));
        consoleTextArea.setLineWrap(true);
        consoleTextArea.setWrapStyleWord(false);
        this.textSearchMap = new LinkedHashMap<JComponent, TextSearch>();
        final TextSearchPanel textSearchPanel = this.textSearchPanel;
        final Map<JComponent, TextSearch> map = this.textSearchMap;
        map.put(databaseInfoTree, databaseInfoTree);
        map.put(resultSetTable, resultSetTable);
        map.put(jTableHeader, new ResultSetTable.TableHeaderTextSearch(resultSetTable, jTableHeader));
        map.put(consoleTextArea, consoleTextArea);
        for (Map.Entry<JComponent, TextSearch> entry : map.entrySet()) {
            final JComponent jComponent = entry.getKey();
            jComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    WindowLauncher.this.focused = jComponent;
                    textSearchPanel.setCurrentTarget((TextSearch)map.get(jComponent));
                }
            });
            textSearchPanel.addTarget(entry.getValue());
        }
        this.statusBar.setForeground(Color.BLUE);
        this.panel2.add((Component)new JScrollPane(consoleTextArea, 22, 31), "Center");
        this.panel2.add((Component)textSearchPanel, "South");
        this.split2.setTopComponent(new JScrollPane(resultSetTable));
        this.split2.setBottomComponent(this.panel2);
        this.op.add((Component)this.panel1, "Center");
        this.op.add((Component)this.statusBar, "Last");
        this.op.setJMenuBar(this.menu);
        this.op.addPropertyChangeListener(this.menu);
        databaseInfoTree.addPropertyChangeListener(this.menu);
        resultSetTable.addPropertyChangeListener(this.menu);
        this.statusBar.addPropertyChangeListener(this.menu);
        this.loadConfiguration();
        this.op.removePropertyChangeListener(this.menu);
        databaseInfoTree.removePropertyChangeListener(this.menu);
        resultSetTable.removePropertyChangeListener(this.menu);
        ContextMenu.create(databaseInfoTree, databaseInfoTree);
        ContextMenu.create(resultSetTable);
        ContextMenu.create(resultSetTable.getRowHeader(), resultSetTable, "ResultSetTable");
        ContextMenu.create(jTableHeader, resultSetTable, "ResultSetTableColumnHeader");
        ContextMenu.createForText(consoleTextArea);
    }

    @Override
    public void launch(Environment environment) {
        this.env = environment;
        this.op.setEnvironment(environment);
        this.op.setVisible(true);
        this.op.output(new Prompt(environment));
        this.textArea.requestFocus();
    }

    @Override
    public void run() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        WindowLauncher.invoke(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        log.fatal(throwable, "%s", thread);
        this.op.showErrorDialog(throwable);
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        log.atEnter("anyActionPerformed", anyActionEvent);
        anyActionEvent.validate();
        try {
            this.resultSetTable.editingCanceled(new ChangeEvent(anyActionEvent.getSource()));
            Object object = anyActionEvent.getSource();
            if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.newWindow})) {
                WindowLauncher.invoke();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.closeWindow})) {
                this.requestClose();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.quit})) {
                this.requestExit();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showInfoTree})) {
                this.setInfoTreePaneVisibility(((JCheckBoxMenuItem)object).isSelected());
                this.op.validate();
                this.op.repaint();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.cut, AnyActionKey.copy, AnyActionKey.paste, AnyActionKey.selectAll})) {
                if (this.focused != null) {
                    String string = anyActionEvent.isAnyOf(new Object[]{AnyActionKey.cut}) ? (this.focused instanceof JTextComponent ? "cut-to-clipboard" : "") : (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.copy}) ? (this.focused instanceof JTextComponent ? "copy-to-clipboard" : anyActionEvent.getActionCommand()) : (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.paste}) ? (this.focused instanceof JTextComponent ? "paste-from-clipboard" : (this.focused instanceof DatabaseInfoTree ? "" : anyActionEvent.getActionCommand())) : (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.selectAll}) ? (this.focused instanceof JTextComponent ? "select-all" : anyActionEvent.getActionCommand()) : "")));
                    if (string.length() == 0) {
                        log.debug("no action: %s, cmd=%s", (Object)this.focused.getClass(), (Object)anyActionEvent.getActionCommand());
                    } else {
                        Action action = this.focused.getActionMap().get(string);
                        log.debug("convert to plain Action Event: orig=%s", (Object)anyActionEvent);
                        action.actionPerformed(new ActionEvent(this.focused, 1001, string));
                    }
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.find})) {
                this.textSearchPanel.setCurrentTarget(this.textSearchMap.get(this.focused));
                this.textSearchPanel.setVisible(true);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.toggleFocus})) {
                if (this.textArea.isFocusOwner()) {
                    this.resultSetTable.requestFocus();
                } else {
                    this.textArea.requestFocus();
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.clearMessage})) {
                this.textArea.clear();
                this.executeCommand("");
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showStatusBar})) {
                this.statusBar.setVisible(((JCheckBoxMenuItem)object).isSelected());
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showColumnNumber})) {
                this.resultSetTable.anyActionPerformed(anyActionEvent);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.refresh})) {
                this.refreshResult();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.autoAdjustModeNone, AnyActionKey.autoAdjustModeHeader, AnyActionKey.autoAdjustModeValue, AnyActionKey.autoAdjustModeHeaderAndValue})) {
                this.resultSetTable.setAutoAdjustMode(anyActionEvent.getActionCommand());
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.widenColumnWidth, AnyActionKey.narrowColumnWidth, AnyActionKey.adjustColumnWidth})) {
                this.resultSetTable.anyActionPerformed(anyActionEvent);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.executeCommand, AnyActionKey.execute})) {
                this.executeCommand(this.textArea.getEditableText());
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.breakCommand})) {
                this.env.getOutputProcessor().close();
                this.env.setOutputProcessor(new WindowOutputProcessor.Bypass(this.op));
                this.op.output(res.get("i.cancelled", new Object[0]));
                this.doPostProcess();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.lastHistory})) {
                this.retrieveHistory(-1);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.nextHistory})) {
                this.retrieveHistory(1);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.sendRollback})) {
                if (this.confirmCommitable() && JOptionPane.showConfirmDialog(this.op, res.get("i.confirm-rollback", new Object[0]), null, 2) == 0) {
                    this.executeCommand("rollback");
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.sendCommit})) {
                if (this.confirmCommitable() && JOptionPane.showConfirmDialog(this.op, res.get("i.confirm-commit", new Object[0]), null, 2) == 0) {
                    this.executeCommand("commit");
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.connect})) {
                this.env.updateConnectorMap();
                if (this.env.getConnectorMap().isEmpty()) {
                    JOptionPane.showMessageDialog(this.op, res.get("w.no-connector", new Object[0]));
                    return;
                }
                Object[] objectArray = ConnectorEntry.toList(this.env.getConnectorMap().values()).toArray();
                String string = res.get("i.choose-connection", new Object[0]);
                Object object2 = JOptionPane.showInputDialog(this.op, string, null, -1, null, objectArray, objectArray[0]);
                if (object2 != null) {
                    ConnectorEntry connectorEntry = (ConnectorEntry)object2;
                    this.executeCommand("connect " + connectorEntry.getId());
                }
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.disconnect})) {
                this.executeCommand("disconnect");
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.postProcessModeNone, AnyActionKey.postProcessModeFocus, AnyActionKey.postProcessModeShake, AnyActionKey.postProcessModeBlink})) {
                this.op.setPostProcessMode(anyActionEvent.getActionCommand());
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.inputEcryptionKey})) {
                this.editEncryptionKey();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.editConnectors})) {
                this.editConnectorMap();
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.sortResult})) {
                this.resultSetTable.doSort(this.resultSetTable.getSelectedColumn());
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.importFile, AnyActionKey.exportFile, AnyActionKey.showAbout})) {
                this.op.anyActionPerformed(anyActionEvent);
            } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showHelp})) {
                WindowLauncher.showHelp();
            } else if (anyActionEvent.isAnyOf(new Object[]{ResultSetTable.ActionKey.findColumnName})) {
                this.resultSetTable.getTableHeader().requestFocus();
                this.textSearchPanel.setVisible(true);
            } else if (anyActionEvent.isAnyOf(new Object[]{ResultSetTable.ActionKey.jumpToColumn})) {
                this.resultSetTable.anyActionPerformed(anyActionEvent);
            } else if (anyActionEvent.isAnyOf(new Object[]{ConsoleTextArea.ActionKey.insertText})) {
                this.textArea.anyActionPerformed(anyActionEvent);
            } else {
                log.warn("not expected: Event=%s", anyActionEvent);
            }
        }
        catch (Exception exception) {
            this.op.showErrorDialog(exception);
        }
        log.atExit("dispatch");
    }

    void setInfoTreePaneVisibility(boolean bl) {
        if (bl) {
            this.split1.removeAll();
            this.split1.setTopComponent(new JScrollPane(this.infoTree));
            this.split1.setBottomComponent(this.split2);
            this.panel1.removeAll();
            this.panel1.add((Component)this.split1, "Center");
            this.infoTree.setEnabled(true);
            if (this.env != null) {
                try {
                    this.infoTree.refreshRoot(this.env);
                }
                catch (SQLException sQLException) {
                    log.error(sQLException);
                    this.op.showErrorDialog(sQLException);
                }
            }
        } else {
            this.infoTree.clear();
            this.infoTree.setEnabled(false);
            this.panel1.removeAll();
            this.panel1.add((Component)this.split2, "Center");
        }
        SwingUtilities.updateComponentTreeUI(this.op);
    }

    private void loadConfiguration() {
        Configuration configuration = Configuration.load();
        this.op.setSize(configuration.getSize());
        this.op.setLocation(configuration.getLocation());
        this.split2.setDividerLocation(configuration.getDividerLocation());
        this.statusBar.setVisible(configuration.isShowStatusBar());
        this.resultSetTable.setShowColumnNumber(configuration.isShowTableColumnNumber());
        this.split1.setDividerLocation(configuration.getDividerLocation0());
        this.op.setAlwaysOnTop(configuration.isAlwaysOnTop());
        this.resultSetTable.setAutoAdjustMode(configuration.getAutoAdjustMode());
        this.op.setPostProcessMode(configuration.getPostProcessMode());
        this.setInfoTreePaneVisibility(configuration.isShowInfoTree());
        this.changeFont("monospaced", 0, 1.0);
    }

    private void saveConfiguration() {
        Configuration configuration = Configuration.load();
        if ((this.op.getExtendedState() & 6) == 0) {
            configuration.setSize(this.op.getSize());
            configuration.setLocation(this.op.getLocation());
            configuration.setDividerLocation(this.split2.getDividerLocation());
            configuration.setDividerLocation0(this.split1.getDividerLocation());
        }
        configuration.setShowStatusBar(this.statusBar.isVisible());
        configuration.setShowTableColumnNumber(this.resultSetTable.isShowColumnNumber());
        configuration.setShowInfoTree(this.infoTree.isEnabled());
        configuration.setAlwaysOnTop(this.op.isAlwaysOnTop());
        configuration.setAutoAdjustMode(this.resultSetTable.getAutoAdjustMode());
        configuration.setPostProcessMode(this.op.getPostProcessMode());
        configuration.save();
    }

    private void changeFont(String string, int n, double d) {
        FontControlLookAndFeel.change(string, n, d);
        SwingUtilities.updateComponentTreeUI(this.op);
        Font font = this.textArea.getFont();
        if (font != null) {
            this.statusBar.setFont(font.deriveFont((float)font.getSize() * 0.8f));
        }
    }

    void handleError(Throwable throwable) {
        log.error(throwable);
        this.op.showErrorDialog(throwable);
    }

    static void invoke() {
        WindowLauncher.invoke(new WindowLauncher());
    }

    static void invoke(WindowLauncher windowLauncher) {
        Environment environment = new Environment();
        environment.setOutputProcessor(new WindowOutputProcessor.Bypass(windowLauncher.op));
        windowLauncher.launch(environment);
    }

    static void exit() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                windowLauncher.close();
            }
            catch (Exception exception) {
                log.warn(exception, (Object)"error occurred when closing all instances");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        instances.remove(this);
        try {
            this.env.release();
            this.saveConfiguration();
            this.executorService.shutdown();
        }
        finally {
            this.op.dispose();
        }
    }

    private boolean confirmYes(String string) {
        return JOptionPane.showConfirmDialog(this.op, string, "", 0) == 0;
    }

    private boolean confirmCommitable() {
        if (this.env.getCurrentConnection() == null) {
            JOptionPane.showMessageDialog(this.op, res.get("w.not-connect", new Object[0]), null, 0);
            return false;
        }
        if (this.env.getCurrentConnector().isReadOnly()) {
            JOptionPane.showMessageDialog(this.op, res.get("w.connector-readonly", new Object[0]), null, 0);
            return false;
        }
        return true;
    }

    private void retrieveHistory(int n) {
        if (this.historyList.isEmpty()) {
            return;
        }
        this.historyIndex += n;
        if (this.historyIndex >= this.historyList.size()) {
            this.historyIndex = 0;
        } else if (this.historyIndex < 0) {
            this.historyIndex = this.historyList.size() - 1;
        }
        this.textArea.replace(this.historyList.get(this.historyIndex));
        int n2 = this.textArea.getEndPosition();
        this.textArea.setSelectionStart(n2);
        this.textArea.moveCaretPosition(n2);
        this.textArea.requestFocus();
    }

    void requestClose() {
        if (instances.size() == 1) {
            this.requestExit();
        } else if (this.env.getCurrentConnection() == null || this.confirmYes(res.get("i.confirm-close", new Object[0]))) {
            this.close();
        }
    }

    void requestExit() {
        if (this.confirmYes(res.get("i.confirm-quit", new Object[0]))) {
            WindowLauncher.exit();
        }
    }

    private void refreshResult() {
        String string;
        ResultSetTableModel resultSetTableModel;
        if (this.resultSetTable.getModel() instanceof ResultSetTableModel && (resultSetTableModel = this.resultSetTable.getResultSetTableModel()).isSameConnection(this.env.getCurrentConnection()) && (string = resultSetTableModel.getCommandString()) != null && string.length() > 0) {
            this.executeCommand(string);
        }
    }

    private void editEncryptionKey() {
        JPasswordField jPasswordField = new JPasswordField(20);
        Object[] objectArray = new Object[]{res.get("i.input-encryption-key", new Object[0]), jPasswordField};
        if (JOptionPane.showConfirmDialog(this.op, objectArray, null, 2) == 0) {
            CipherPassword.setSecretKey(String.valueOf(jPasswordField.getPassword()));
        }
    }

    private void editConnectorMap() {
        this.env.updateConnectorMap();
        if (this.env.getCurrentConnector() != null) {
            JOptionPane.showMessageDialog(this.op, res.get("i.reconnect-after-edited-current-connector", new Object[0]));
        }
        ConnectorMapEditDialog connectorMapEditDialog = new ConnectorMapEditDialog(this.op, this.env);
        connectorMapEditDialog.pack();
        connectorMapEditDialog.setModal(true);
        connectorMapEditDialog.setLocationRelativeTo(this.op);
        connectorMapEditDialog.setVisible(true);
        this.env.updateConnectorMap();
    }

    private static void showHelp() {
        Object object;
        File file = new File("MANUAL_" + Locale.getDefault().getLanguage() + ".html");
        File file2 = file.exists() ? file : new File("MANUAL.html");
        boolean bl = false;
        if (Desktop.isDesktopSupported() && ((Desktop)(object = Desktop.getDesktop())).isSupported(Desktop.Action.OPEN) && file2.exists()) {
            try {
                ((Desktop)object).open(file2);
                bl = true;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (!bl) {
            object = String.format("%s%nfile=%s", res.get("e.cannot-open-help-automatically", file2), file2.getAbsolutePath());
            WindowOutputProcessor.showInformationMessageDialog(JOptionPane.getRootFrame(), (String)object, "");
        }
    }

    void executeCommand(String string) {
        assert (string != null);
        if (!string.equals(this.textArea.getEditableText())) {
            this.textArea.replace(string);
        }
        this.op.output("");
        if (string.trim().length() == 0) {
            this.doPostProcess();
        } else {
            final String string2 = string;
            final Environment environment = this.env;
            final DatabaseInfoTree databaseInfoTree = this.infoTree;
            final JLabel jLabel = this.statusBar;
            final OutputProcessor outputProcessor = environment.getOutputProcessor();
            try {
                this.doPreProcess();
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        Connection connection = environment.getCurrentConnection();
                        long l = System.currentTimeMillis();
                        if (!Command.invoke(environment, string2)) {
                            WindowLauncher.exit();
                        }
                        if (databaseInfoTree.isEnabled()) {
                            try {
                                if (environment.getCurrentConnection() != connection) {
                                    databaseInfoTree.clear();
                                    if (environment.getCurrentConnection() != null) {
                                        databaseInfoTree.refreshRoot(environment);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                WindowLauncher.this.handleError(throwable);
                            }
                        }
                        if (environment.getOutputProcessor() == outputProcessor) {
                            l = System.currentTimeMillis() - l;
                            jLabel.setText(res.get("i.statusbar-message", Float.valueOf((float)l / 1000.0f), string2));
                            AnyAction anyAction = new AnyAction(this);
                            anyAction.doLater("callDoPostProcess", new Object[0]);
                        }
                    }

                    void callDoPostProcess() {
                        WindowLauncher.this.doPostProcess();
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                this.historyIndex = this.historyList.size();
            }
            if (this.historyList.contains(string)) {
                this.historyList.remove(string);
            }
            this.historyList.add(string);
        }
        this.historyIndex = this.historyList.size();
    }

    void doPreProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(true);
        this.resultSetTable.setEnabled(false);
        this.textArea.setEnabled(false);
        this.op.repaint();
    }

    void doPostProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(false);
        this.resultSetTable.setEnabled(true);
        this.textArea.setEnabled(true);
        this.op.output(new Prompt(this.env));
        this.op.doPostProcess();
    }

    static void wakeup() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                SwingUtilities.updateComponentTreeUI(windowLauncher.op);
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        }
        log.info("wake up");
    }

    public static void main(String ... stringArray) {
        int n = Bootstrap.getPropertyAsInt("net.argius.stew.ui.window.resident", 0);
        if (n > 0) {
            long l = (long)n * 60000L;
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate((TimerTask)new WakeupTimerTask(), l, l);
        }
        EventQueue.invokeLater(new WindowLauncher());
    }

    private static final class WakeupTimerTask
    extends TimerTask {
        private final AnyAction aa = new AnyAction(this);

        private WakeupTimerTask() {
        }

        @Override
        public void run() {
            this.aa.doLater("callWakeup", new Object[0]);
        }

        void callWakeup() {
            WindowLauncher.wakeup();
        }
    }

    public static final class Configuration {
        private static final Logger log = Logger.getLogger(Configuration.class);
        private Dimension size = new Dimension(640, 480);
        private Point location = new Point(200, 200);
        private int dividerLocation = -1;
        private int dividerLocation0 = -1;
        private boolean showStatusBar = false;
        private boolean showTableColumnNumber = false;
        private boolean showInfoTree = false;
        private boolean alwaysOnTop = false;
        private String autoAdjustMode = AnyActionKey.autoAdjustMode.toString();
        private String postProcessMode = AnyActionKey.postProcessMode.toString();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save() {
            File file = Configuration.getFile();
            log.debug("save Configuration to: [%s]", (Object)file.getAbsolutePath());
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file));
                try {
                    xMLEncoder.writeObject(this);
                }
                finally {
                    xMLEncoder.close();
                }
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Configuration load() {
            File file = Configuration.getFile();
            log.debug("load Configuration from: [%s]", (Object)file.getAbsolutePath());
            if (file.exists()) {
                XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(file));
                try {
                    Configuration configuration = (Configuration)xMLDecoder.readObject();
                    xMLDecoder.close();
                    return configuration;
                }
                catch (Throwable throwable) {
                    try {
                        xMLDecoder.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        log.warn(exception);
                    }
                }
            }
            return new Configuration();
        }

        private static File getFile() {
            return Bootstrap.getSystemFile(Configuration.class.getName() + ".xml");
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) {
            this.size = dimension;
        }

        public Point getLocation() {
            return this.location;
        }

        public void setLocation(Point point) {
            this.location = point;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }

        public int getDividerLocation0() {
            return this.dividerLocation0;
        }

        public void setDividerLocation0(int n) {
            this.dividerLocation0 = n;
        }

        public boolean isShowStatusBar() {
            return this.showStatusBar;
        }

        public void setShowStatusBar(boolean bl) {
            this.showStatusBar = bl;
        }

        public boolean isShowTableColumnNumber() {
            return this.showTableColumnNumber;
        }

        public void setShowTableColumnNumber(boolean bl) {
            this.showTableColumnNumber = bl;
        }

        public boolean isShowInfoTree() {
            return this.showInfoTree;
        }

        public void setShowInfoTree(boolean bl) {
            this.showInfoTree = bl;
        }

        public boolean isAlwaysOnTop() {
            return this.alwaysOnTop;
        }

        public void setAlwaysOnTop(boolean bl) {
            this.alwaysOnTop = bl;
        }

        public String getAutoAdjustMode() {
            return this.autoAdjustMode;
        }

        public void setAutoAdjustMode(String string) {
            this.autoAdjustMode = string;
        }

        public String getPostProcessMode() {
            return this.postProcessMode;
        }

        public void setPostProcessMode(String string) {
            this.postProcessMode = string;
        }
    }
}

