/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import net.argius.stew.Bootstrap;
import net.argius.stew.Command;
import net.argius.stew.Environment;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.text.TextUtilities;
import net.argius.stew.ui.Launcher;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.console.ConnectorMapEditor;
import net.argius.stew.ui.console.ConsoleOutputProcessor;

public final class ConsoleLauncher
implements Launcher {
    private static Logger log = Logger.getLogger(ConsoleLauncher.class);
    private static final boolean END = false;

    @Override
    public void launch(Environment environment) {
        log.info("start");
        OutputProcessor outputProcessor = environment.getOutputProcessor();
        Prompt prompt = new Prompt(environment);
        Scanner scanner = new Scanner(System.in);
        while (true) {
            outputProcessor.output(prompt);
            if (!scanner.hasNextLine()) break;
            String string = scanner.nextLine();
            log.debug("input : %s", (Object)string);
            if (String.valueOf(string).trim().equals("--edit")) {
                ConnectorMapEditor.invoke();
                environment.updateConnectorMap();
                continue;
            }
            if (!Command.invoke(environment, string)) break;
        }
        log.info("end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        if (arrayList.contains("-v") || arrayList.contains("--version")) {
            System.out.println("Stew " + Bootstrap.getVersion());
            return;
        }
        Environment environment = new Environment();
        try {
            environment.setOutputProcessor(new ConsoleOutputProcessor());
            String string = ResourceManager.Default.get(".about", Bootstrap.getVersion());
            environment.getOutputProcessor().output(string);
            if (!arrayList.isEmpty() && !((String)arrayList.get(0)).startsWith("-")) {
                Command.invoke(environment, "connect " + (String)arrayList.remove(0));
            }
            if (!arrayList.isEmpty()) {
                Command.invoke(environment, TextUtilities.join(" ", arrayList));
                Command.invoke(environment, "disconnect");
            } else {
                ConsoleLauncher consoleLauncher = new ConsoleLauncher();
                consoleLauncher.launch(environment);
            }
        }
        finally {
            environment.release();
        }
    }
}

