/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.console.ConsoleLauncher;
import net.argius.stew.ui.window.WindowLauncher;

public final class Bootstrap {
    private static final Logger log = Logger.getLogger(Bootstrap.class);
    private static final String PropKey = "net.argius.stew.properties";
    private static final String PropFileName = "stew.properties";
    private static final String DefaultDir = ".stew";
    private static final File dir = Bootstrap.initializeDirectory();
    private static Properties props = Bootstrap.initializeProperties();

    private static File initializeDirectory() {
        File file;
        String string = System.getProperty(PropKey, System.getProperty(PropFileName, ""));
        if (string.length() == 0) {
            file = new File(DefaultDir);
        } else {
            File file2 = new File(string);
            if (file2.isDirectory()) {
                file = file2;
            } else {
                file = file2.getParentFile();
                if (file == null) {
                    file = new File(DefaultDir);
                }
            }
        }
        try {
            if (!(file.isDirectory() || file.mkdirs() && file.isDirectory())) {
                throw new IOException("can't make directory: " + file);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return file;
    }

    private static Properties initializeProperties() {
        Properties properties = System.getProperties();
        Properties properties2 = new Properties(properties);
        try {
            properties2.putAll((Map<?, ?>)Bootstrap.getFileProperties());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Properties properties3 = new Properties(properties2);
        if (log.isDebugEnabled()) {
            int n = 3;
            for (Properties properties4 : new Properties[]{properties, properties2}) {
                Object object2;
                ArrayList<String> arrayList = new ArrayList<String>(properties4.size());
                for (Object object2 : properties4.keySet()) {
                    arrayList.add((String)object2);
                }
                Collections.sort(arrayList);
                StringWriter stringWriter = new StringWriter();
                object2 = new PrintWriter(stringWriter);
                ((PrintWriter)object2).println();
                ((PrintWriter)object2).println("--- property group " + n-- + " ---");
                for (String string : arrayList) {
                    ((PrintWriter)object2).println(string + '=' + properties4.getProperty(string));
                }
                log.setEnteredMethodName("initializeProperties");
                log.debug(stringWriter);
                log.setEnteredMethodName("");
            }
        }
        return properties3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFileProperties() throws IOException {
        InputStream inputStream;
        Object object;
        Properties properties = new Properties();
        String string = System.getProperty(PropFileName);
        if (string != null) {
            object = new File(string);
            if (((File)object).isDirectory()) {
                object = new File((File)object, PropFileName);
            }
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                try {
                    properties.load(fileInputStream);
                    Properties properties2 = properties;
                    return properties2;
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        if ((inputStream = Bootstrap.class.getResourceAsStream((String)(object = "/stew.properties"))) != null) {
            try {
                properties.load(inputStream);
                Properties properties3 = properties;
                return properties3;
            }
            finally {
                inputStream.close();
            }
        }
        File file = new File(dir, PropFileName);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Properties properties4 = properties;
                return properties4;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return properties;
    }

    public static File getSystemDirectory() {
        return dir;
    }

    public static File getSystemFile(String string) {
        return new File(dir, string);
    }

    public static String getProperty(String string) {
        return props.getProperty(string, "");
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static int getPropertyAsInt(String string, int n) {
        if (props.getProperty(string) != null) {
            try {
                return Integer.parseInt(props.getProperty(string, ""));
            }
            catch (NumberFormatException numberFormatException) {
                log.warn(numberFormatException);
            }
        }
        return n;
    }

    public static boolean getPropertyAsBoolean(String string) {
        return Boolean.valueOf(props.getProperty(string, ""));
    }

    public static boolean hasProperty(String string) {
        return props.containsKey(string);
    }

    public static String getVersion() {
        return ResourceManager.Default.read("version", "(UNKNOWN)");
    }

    public static void main(String ... stringArray) {
        int n = 0;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.matches("(?i)\\s*--GUI\\s*")) {
                ++n;
                continue;
            }
            if (string.matches("(?i)\\s*--CUI\\s*")) {
                ++n2;
                continue;
            }
            arrayList.add(string);
        }
        if (n == 0 && n2 == 0) {
            for (String string : new String[]{"stew.bootstrap", "stew.boot", "net.argius.stew.bootstrap", "net.argius.stew.boot"}) {
                String string2 = props.getProperty(string, "");
                if (string2.equalsIgnoreCase("GUI")) {
                    ++n;
                }
                if (!string2.equalsIgnoreCase("CUI")) continue;
                ++n2;
            }
        }
        if (n > 0 && n2 > 0) {
            throw new IllegalArgumentException("bad option: both --gui and --cui were specified.");
        }
        log.debug("cui=%d, gui=%d, new-args=%s", n2, n, arrayList);
        if (n > 0) {
            WindowLauncher.main(new String[0]);
        } else {
            ConsoleLauncher.main(arrayList.toArray(new String[arrayList.size()]));
        }
    }
}

