/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class Menu
extends JMenuBar
implements PropertyChangeListener {
    private static final ResourceManager res = ResourceManager.getInstance(Menu.class);
    private List<JMenuItem> lockingTargets = new ArrayList<JMenuItem>();
    private List<JMenuItem> unlockingTargets = new ArrayList<JMenuItem>();
    private EnumMap<Item, JMenuItem> itemToCompMap = new EnumMap(Item.class);
    private Map<JMenuItem, Item> compToItemMap = new HashMap<JMenuItem, Item>();

    Menu(AnyActionListener anyActionListener) {
        boolean bl = res.getInt("auto-mnemonic") == 1;
        AnyAction anyAction = new AnyAction(anyActionListener);
        for (String string : res.get("groups", new Object[0]).split(",", -1)) {
            String string2 = "group." + string;
            JMenu jMenu = this.add(Menu.buildGroup(string, bl));
            block7: for (String string3 : res.get(string2 + ".items", new Object[0]).split(",", -1)) {
                KeyStroke keyStroke;
                Item item;
                if (string3.length() == 0) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                JMenuItem jMenuItem = jMenu.add(this.buildItem(string3, bl));
                try {
                    item = Item.valueOf(string3);
                }
                catch (Exception exception) {
                    assert (false) : exception.toString();
                    continue;
                }
                jMenuItem.addActionListener(anyAction);
                this.itemToCompMap.put(item, jMenuItem);
                this.compToItemMap.put(jMenuItem, item);
                String string4 = "item." + string3 + ".shortcut";
                if (res.containsKey(string4) && (keyStroke = KeyStroke.getKeyStroke(res.get(string4, new Object[0]))) != null) {
                    this.setAccelerator(item, keyStroke);
                }
                switch (item) {
                    case closeWindow: 
                    case quit: 
                    case cut: 
                    case copy: 
                    case paste: 
                    case selectAll: 
                    case find: 
                    case clearMessage: 
                    case refresh: 
                    case widenColumnWidth: 
                    case narrowColumnWidth: 
                    case adjustColumnWidth: 
                    case autoAdjustMode: 
                    case executeCommand: 
                    case lastHistory: 
                    case nextHistory: 
                    case connect: 
                    case disconnect: 
                    case postProcessMode: 
                    case sortResult: 
                    case exportFile: {
                        this.lockingTargets.add(jMenuItem);
                        continue block7;
                    }
                    case breakCommand: {
                        this.unlockingTargets.add(jMenuItem);
                        continue block7;
                    }
                }
            }
        }
        for (Item item : EnumSet.of(Item.autoAdjustModeNone, new Item[]{Item.autoAdjustModeHeader, Item.autoAdjustModeValue, Item.autoAdjustModeHeaderAndValue, Item.postProcessMode, Item.postProcessModeNone, Item.postProcessModeFocus, Item.postProcessModeShake, Item.postProcessModeBlink})) {
            this.itemToCompMap.get((Object)item).addActionListener(anyAction);
        }
        this.setEnabledStates(false);
    }

    private static JMenu buildGroup(String string, boolean bl) {
        String string2 = (res.containsKey("group." + string) ? "group" : "item") + '.' + string;
        char c = res.getChar(string2 + ".mnemonic");
        String string3 = res.get(string2, new Object[0]) + (bl ? "(" + c + ")" : "");
        JMenu jMenu = new JMenu(string3);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    private JMenuItem buildItem(String string, boolean bl) {
        JMenuItem jMenuItem;
        String string2 = "item." + string;
        char c = res.getChar(string2 + ".mnemonic");
        if (res.isTrue(string2 + ".checkbox")) {
            jMenuItem = new JCheckBoxMenuItem();
        } else if (res.isTrue(string2 + ".subgroup")) {
            jMenuItem = Menu.buildGroup(string, bl);
            ButtonGroup buttonGroup = new ButtonGroup();
            boolean bl2 = false;
            for (String string3 : res.get(string2 + ".items", new Object[0]).split(",", -1)) {
                JMenuItem jMenuItem2 = this.buildItem(string + string3, bl);
                jMenuItem.add(jMenuItem2);
                buttonGroup.add(jMenuItem2);
                if (!bl2) {
                    jMenuItem2.setSelected(true);
                    bl2 = true;
                }
                Item item = Item.valueOf(string + string3);
                this.itemToCompMap.put(item, jMenuItem2);
                this.compToItemMap.put(jMenuItem2, item);
            }
        } else {
            jMenuItem = new JMenuItem();
        }
        jMenuItem.setText(res.get(string2, new Object[0]) + (bl ? "(" + c + ")" : ""));
        jMenuItem.setMnemonic(c);
        jMenuItem.setActionCommand(string);
        jMenuItem.setIcon(Utilities.getImageIcon(String.format("menu-%s.png", string)));
        jMenuItem.setDisabledIcon(Utilities.getImageIcon(String.format("menu-disabled-%s.png", string)));
        return jMenuItem;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        String string2 = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JLabel && string2.equals("ancestor")) {
            this.itemToCompMap.get((Object)Item.showStatusBar).setSelected(((JLabel)object).isVisible());
        } else if (object instanceof ResultSetTable && string2.equals("showNumber")) {
            this.itemToCompMap.get((Object)Item.showColumnNumber).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof DatabaseInfoTree) {
            this.itemToCompMap.get((Object)Item.showInfoTree).setSelected(((Component)object).isEnabled());
        } else if (object instanceof JFrame && string2.equals("alwaysOnTop")) {
            this.itemToCompMap.get((Object)Item.showAlwaysOnTop).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof WindowOutputProcessor && string2.equals("autoAdjustMode|postProcessMode") && !(string = propertyChangeEvent.getNewValue().toString()).matches("[A-Z_]+")) {
            this.itemToCompMap.get((Object)Item.valueOf(string)).setSelected(true);
        }
    }

    void setAccelerator(Item item, KeyStroke keyStroke) {
        int n = 0;
        String string = keyStroke.toString();
        if (string.contains("ctrl")) {
            n |= Utilities.getMenuShortcutKeyMask();
        }
        if (string.contains("alt")) {
            n |= 0x200;
        }
        if (string.contains("shift")) {
            n |= 0x40;
        }
        this.itemToCompMap.get((Object)item).setAccelerator(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n));
    }

    void setEnabledStates(boolean bl) {
        boolean bl2 = !bl;
        for (JMenuItem object : this.lockingTargets) {
            object.setEnabled(bl2);
        }
        boolean bl3 = bl;
        for (JMenuItem jMenuItem : this.unlockingTargets) {
            jMenuItem.setEnabled(bl3);
        }
    }

    static enum Item {
        newWindow,
        closeWindow,
        quit,
        cut,
        copy,
        paste,
        selectAll,
        find,
        toggleFocus,
        clearMessage,
        showStatusBar,
        showColumnNumber,
        showInfoTree,
        showAlwaysOnTop,
        refresh,
        widenColumnWidth,
        narrowColumnWidth,
        adjustColumnWidth,
        autoAdjustMode,
        autoAdjustModeNone,
        autoAdjustModeHeader,
        autoAdjustModeValue,
        autoAdjustModeHeaderAndValue,
        executeCommand,
        breakCommand,
        lastHistory,
        nextHistory,
        sendRollback,
        sendCommit,
        connect,
        disconnect,
        postProcessMode,
        postProcessModeNone,
        postProcessModeFocus,
        postProcessModeShake,
        postProcessModeBlink,
        inputEcryptionKey,
        editConnectors,
        sortResult,
        importFile,
        exportFile,
        showHelp,
        showAbout;

    }
}

