/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.argius.stew.DaemonThreadFactory;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.Utilities;

final class AnyAction
extends AbstractAction
implements Runnable {
    private Object o;
    private Map<String, Method> m;
    private String eventCommand;
    private boolean canListenAnyAction;
    private boolean hasInputMap;

    AnyAction(Object object) {
        this(object, "");
    }

    AnyAction(Object object, String string) {
        super(string);
        if (string == null) {
            throw new IllegalArgumentException("eventCommand is null");
        }
        this.o = object;
        this.m = new LinkedHashMap<String, Method>();
        this.eventCommand = string;
        this.canListenAnyAction = object instanceof AnyActionListener;
        this.hasInputMap = object instanceof JComponent;
    }

    void doNow(String string, Object ... objectArray) {
        try {
            this.resolveMethod(string).invoke(this.o, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("at AnyAction#doNow", exception);
        }
    }

    void doLater(String string, Object ... objectArray) {
        EventQueue.invokeLater(new Task("AnyAction#doLater", this.o, this.resolveMethod(string), objectArray));
    }

    void doParallel(String string, Object ... objectArray) {
        DaemonThreadFactory.execute(new Task("AnyAction#doParallel", this.o, this.resolveMethod(string), objectArray));
    }

    private Method resolveMethod(String string) {
        if (this.m.containsKey(string)) {
            return this.m.get(string);
        }
        for (Method method : this.o.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(string)) continue;
            method.setAccessible(true);
            this.m.put(string, method);
            return method;
        }
        throw new IllegalArgumentException("method not found: " + string);
    }

    @Override
    public void run() {
        this.actionPerformed(new ActionEvent(this.o, 0, this.eventCommand));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.canListenAnyAction) {
            throw new RuntimeException(AnyAction.editErrorMessage(1, actionEvent));
        }
        String string = this.eventCommand.length() == 0 ? actionEvent.getActionCommand() : this.eventCommand;
        AnyActionEvent anyActionEvent = new AnyActionEvent(actionEvent.getSource(), string, new Object[0]);
        ((AnyActionListener)this.o).anyActionPerformed(anyActionEvent);
    }

    void bind(AnyActionListener anyActionListener, Object object, KeyStroke ... keyStrokeArray) {
        this.bind(anyActionListener, false, object, keyStrokeArray);
    }

    void bind(AnyActionListener anyActionListener, boolean bl, Object object, KeyStroke ... keyStrokeArray) {
        if (!this.hasInputMap && keyStrokeArray.length > 0) {
            throw new RuntimeException(AnyAction.editErrorMessage(2, this.o));
        }
        AnyAction.bind((JComponent)this.o, anyActionListener, bl, object, keyStrokeArray);
    }

    void bindKeyStroke(boolean bl, Object object, KeyStroke ... keyStrokeArray) {
        if (!this.hasInputMap && keyStrokeArray.length > 0) {
            throw new RuntimeException(AnyAction.editErrorMessage(2, this.o));
        }
        AnyAction.bindKeyStroke((JComponent)this.o, bl, String.valueOf(object), keyStrokeArray);
    }

    void bindSelf(Object object, KeyStroke ... keyStrokeArray) {
        if (!this.canListenAnyAction) {
            throw new RuntimeException(AnyAction.editErrorMessage(1, this.o));
        }
        if (keyStrokeArray.length > 0 && !this.hasInputMap) {
            throw new RuntimeException(AnyAction.editErrorMessage(2, this.o));
        }
        AnyAction.bind((JComponent)this.o, (AnyActionListener)this.o, false, object, keyStrokeArray);
    }

    UndoManager setUndoAction() {
        if (this.o instanceof JTextComponent) {
            return AnyAction.setUndoAction((JTextComponent)this.o);
        }
        throw new RuntimeException(AnyAction.editErrorMessage(3, this.o));
    }

    static UndoManager setUndoAction(JTextComponent jTextComponent) {
        UndoManager undoManager = new UndoManager();
        if (jTextComponent == null) {
            return undoManager;
        }
        jTextComponent.getDocument().addUndoableEditListener(undoManager);
        ActionMap actionMap = jTextComponent.getActionMap();
        InputMap inputMap = jTextComponent.getInputMap();
        int n = Utilities.getMenuShortcutKeyMask();
        actionMap.put("undo", new UndoAction(undoManager));
        inputMap.put(KeyStroke.getKeyStroke(90, n), "undo");
        actionMap.put("redo", new RedoAction(undoManager));
        inputMap.put(KeyStroke.getKeyStroke(89, n), "redo");
        return undoManager;
    }

    static String editErrorMessage(int n, Object object) {
        String string = AnyAction.getClassName(object);
        switch (n) {
            case 0: {
                return "unexpected error";
            }
            case 1: {
                return String.format("%s can not listen AnyAction", string);
            }
            case 2: {
                return String.format("%s does not have InputMap", string);
            }
            case 3: {
                return String.format("This is not JTextComponent, but %s", string);
            }
        }
        return "";
    }

    private static void bind(JComponent jComponent, AnyActionListener anyActionListener, boolean bl, Object object, KeyStroke ... keyStrokeArray) {
        String string = String.valueOf(object);
        AnyAction.bindAction(jComponent, anyActionListener, string, keyStrokeArray);
        AnyAction.bindKeyStroke(jComponent, bl, string, keyStrokeArray);
    }

    private static void bindAction(JComponent jComponent, AnyActionListener anyActionListener, String string, KeyStroke ... keyStrokeArray) {
        jComponent.getActionMap().put(string, new AnyAction(anyActionListener, string));
    }

    private static void bindKeyStroke(JComponent jComponent, boolean bl, String string, KeyStroke ... keyStrokeArray) {
        if (keyStrokeArray != null) {
            int n = bl ? 1 : 0;
            for (KeyStroke keyStroke : keyStrokeArray) {
                jComponent.getInputMap(n).put(keyStroke, string);
            }
        }
    }

    private static String getClassName(Object object) {
        return object == null ? "null" : object.getClass().getSimpleName();
    }

    private static final class RedoAction
    extends AbstractAction {
        private UndoManager um;

        RedoAction(UndoManager undoManager) {
            this.um = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.um.canRedo()) {
                this.um.redo();
            }
        }
    }

    private static final class UndoAction
    extends AbstractAction {
        private UndoManager um;

        UndoAction(UndoManager undoManager) {
            this.um = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.um.canUndo()) {
                this.um.undo();
            }
        }
    }

    private static final class Task
    implements Runnable {
        private final String label;
        private final Object o;
        private final Method method;
        private final Object[] args;

        Task(String string, Object object, Method method, Object ... objectArray) {
            this.label = string;
            this.o = object;
            this.method = method;
            this.args = objectArray;
        }

        @Override
        public void run() {
            try {
                this.method.invoke(this.o, this.args);
            }
            catch (Exception exception) {
                throw new RuntimeException("at " + this.label, exception);
            }
        }
    }
}

