/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Logger;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Time
extends Command {
    private static final Logger log = Logger.getLogger(Time.class);

    @Override
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        int n;
        String string;
        if (!parameter.has(1)) {
            throw new UsageException(this.getUsage());
        }
        int n2 = 0;
        if ((string = parameter.at(++n2)).matches("\\d+")) {
            ++n2;
            int n3 = 1;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("", numberFormatException);
            }
            n = n3;
        } else {
            n = 1;
        }
        if (!parameter.has(n2)) {
            throw new UsageException(this.getUsage());
        }
        String string2 = parameter.after(n2);
        try {
            if (n > 1) {
                this.tryManyTimes(connection, string2, n);
            } else {
                this.tryOnce(connection, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOnce(Connection connection, String string) throws SQLException {
        log.debug("tryOnce");
        Statement statement = this.prepareStatement(connection, string);
        try {
            long l;
            long l2;
            if (Time.isSelect(string)) {
                l2 = System.currentTimeMillis();
                ResultSet resultSet = this.executeQuery(statement, string);
                try {
                    l = System.currentTimeMillis();
                }
                finally {
                    resultSet.close();
                }
            } else {
                l2 = System.currentTimeMillis();
                statement.executeUpdate(string);
                l = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug("beginning: " + l2);
                log.debug("      end: " + l);
            }
            this.outputMessage("Time.once", Float.valueOf((float)(l - l2) / 1000.0f));
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryManyTimes(Connection connection, String string, int n) throws SQLException {
        log.debug("tryManyTimes");
        boolean bl = Time.isSelect(string);
        Statement statement = this.prepareStatement(connection, string);
        try {
            long l = 0L;
            long l2 = 0L;
            long l3 = Long.MAX_VALUE;
            for (int i = 1; i <= n; ++i) {
                long l4;
                long l5;
                log.trace("beginning: %d", (Object)i);
                if (bl) {
                    l5 = System.currentTimeMillis();
                    ResultSet resultSet = this.executeQuery(statement, string);
                    try {
                        l4 = System.currentTimeMillis();
                    }
                    finally {
                        resultSet.close();
                    }
                } else {
                    l5 = System.currentTimeMillis();
                    statement.executeUpdate(string);
                    l4 = System.currentTimeMillis();
                }
                log.trace("      end: %d", (Object)i);
                long l6 = l4 - l5;
                l += l6;
                l2 = Math.max(l6, l2);
                l3 = Math.min(l6, l3);
            }
            this.outputMessage("Time.summary", Float.valueOf((float)l / 1000.0f), Float.valueOf((float)l / 1000.0f / (float)n), Float.valueOf((float)l2 / 1000.0f), Float.valueOf((float)l3 / 1000.0f));
        }
        finally {
            statement.close();
        }
    }
}

