/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class Menu
extends JMenuBar
implements PropertyChangeListener {
    private static final ResourceManager res = ResourceManager.getInstance(Menu.class);
    private List<JMenuItem> lockingTargets = new ArrayList<JMenuItem>();
    private List<JMenuItem> unlockingTargets = new ArrayList<JMenuItem>();
    private EnumMap<Item, JMenuItem> itemToCompMap = new EnumMap(Item.class);
    private Map<JMenuItem, Item> compToItemMap = new HashMap<JMenuItem, Item>();

    Menu() {
        boolean bl = res.getInt("auto-mnemonic") == 1;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.fireActionPerformed(actionEvent.getSource(), Item.valueOf(actionEvent.getActionCommand().replace('.', '_')));
            }
        };
        for (String string : res.get("groups", new Object[0]).split(",", -1)) {
            String string2 = "group." + string;
            JMenu jMenu = this.add(Menu.buildGroup(string, bl));
            block7: for (String string3 : res.get(string2 + ".items", new Object[0]).split(",", -1)) {
                KeyStroke keyStroke;
                Item item;
                if (string3.length() == 0) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                JMenuItem jMenuItem = jMenu.add(this.buildItem(string3, bl));
                jMenuItem.addActionListener(actionListener);
                try {
                    item = Item.valueOf(string3);
                }
                catch (Exception exception) {
                    assert (false) : exception.toString();
                    continue;
                }
                this.itemToCompMap.put(item, jMenuItem);
                this.compToItemMap.put(jMenuItem, item);
                String string4 = "item." + string3 + ".shortcut";
                if (res.containsKey(string4) && (keyStroke = KeyStroke.getKeyStroke(res.get(string4, new Object[0]))) != null) {
                    this.setAccelerator(item, keyStroke);
                }
                switch (item) {
                    case CLOSE: 
                    case QUIT: 
                    case CUT: 
                    case COPY: 
                    case PASTE: 
                    case SELECT_ALL: 
                    case FIND: 
                    case CLEAR_MESSAGE: 
                    case REFRESH: 
                    case WIDEN_COLUMN_WIDTH: 
                    case NARROW_COLUMN_WIDTH: 
                    case ADJUST_COLUMN_WIDTH: 
                    case AUTO_ADJUST_MODE: 
                    case EXECUTE: 
                    case HISTORY_BACK: 
                    case HISTORY_NEXT: 
                    case CONNECT: 
                    case DISCONNECT: 
                    case SORT: 
                    case EXPORT: {
                        this.lockingTargets.add(jMenuItem);
                        continue block7;
                    }
                    case BREAK: {
                        this.unlockingTargets.add(jMenuItem);
                        continue block7;
                    }
                }
            }
        }
        for (Item item : EnumSet.of(Item.AUTO_ADJUST_MODE_NONE, new Item[]{Item.AUTO_ADJUST_MODE_HEADER, Item.AUTO_ADJUST_MODE_VALUE, Item.AUTO_ADJUST_MODE_HEADERANDVALUE, Item.POST_PROCESS_MODE_NONE, Item.POST_PROCESS_MODE_FOCUS, Item.POST_PROCESS_MODE_SHAKE, Item.POST_PROCESS_MODE_BLINK})) {
            this.itemToCompMap.get((Object)item).addActionListener(actionListener);
        }
        this.setEnabledStates(false);
    }

    private static JMenu buildGroup(String string, boolean bl) {
        String string2 = (res.containsKey("group." + string) ? "group" : "item") + '.' + string;
        char c = res.getChar(string2 + ".mnemonic");
        String string3 = res.get(string2, new Object[0]) + (bl ? "(" + c + ")" : "");
        JMenu jMenu = new JMenu(string3);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    private JMenuItem buildItem(String string, boolean bl) {
        JMenuItem jMenuItem;
        String string2 = "item." + string;
        char c = res.getChar(string2 + ".mnemonic");
        if (res.isTrue(string2 + ".checkbox")) {
            jMenuItem = new JCheckBoxMenuItem();
        } else if (res.isTrue(string2 + ".subgroup")) {
            jMenuItem = Menu.buildGroup(string, bl);
            ButtonGroup buttonGroup = new ButtonGroup();
            boolean bl2 = false;
            for (String string3 : res.get(string2 + ".items", new Object[0]).split(",", -1)) {
                JMenuItem jMenuItem2 = this.buildItem(string + '.' + string3, bl);
                jMenuItem.add(jMenuItem2);
                buttonGroup.add(jMenuItem2);
                if (!bl2) {
                    jMenuItem2.setSelected(true);
                    bl2 = true;
                }
                Item item = Item.valueOf(string + '_' + string3);
                this.itemToCompMap.put(item, jMenuItem2);
                this.compToItemMap.put(jMenuItem2, item);
            }
        } else {
            jMenuItem = new JMenuItem();
        }
        jMenuItem.setText(res.get(string2, new Object[0]) + (bl ? "(" + c + ")" : ""));
        jMenuItem.setMnemonic(c);
        jMenuItem.setActionCommand(string);
        jMenuItem.setIcon(Resource.getImageIcon(String.format("menu-%s.png", string)));
        jMenuItem.setDisabledIcon(Resource.getImageIcon(String.format("menu-disabled-%s.png", string)));
        return jMenuItem;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JLabel && string.equals("ancestor")) {
            this.itemToCompMap.get((Object)Item.STATUS_BAR).setSelected(((JLabel)object).isVisible());
        } else if (object instanceof ResultSetTable && string.equals("showNumber")) {
            this.itemToCompMap.get((Object)Item.COLUMN_NUMBER).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof DatabaseInfoTree) {
            this.itemToCompMap.get((Object)Item.INFO_TREE).setSelected(((Component)object).isEnabled());
        } else if (object instanceof JFrame && string.equals("alwaysOnTop")) {
            this.itemToCompMap.get((Object)Item.ALWAYS_ON_TOP).setSelected((Boolean)propertyChangeEvent.getNewValue());
        } else if (object instanceof WindowOutputProcessor && string.equals("autoAdjustMode")) {
            this.itemToCompMap.get((Object)Item.valueOf(propertyChangeEvent.getNewValue().toString())).setSelected(true);
        } else if (object instanceof WindowOutputProcessor && string.equals("postProcessMode")) {
            this.itemToCompMap.get((Object)Item.valueOf(propertyChangeEvent.getNewValue().toString())).setSelected(true);
        }
    }

    void setAccelerator(Item item, KeyStroke keyStroke) {
        int n = 0;
        String string = keyStroke.toString();
        if (string.contains("ctrl")) {
            n |= Resource.getMenuShortcutKeyMask();
        }
        if (string.contains("alt")) {
            n |= 0x200;
        }
        if (string.contains("shift")) {
            n |= 0x40;
        }
        this.itemToCompMap.get((Object)item).setAccelerator(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n));
    }

    void setEnabledStates(boolean bl) {
        boolean bl2 = !bl;
        for (JMenuItem object : this.lockingTargets) {
            object.setEnabled(bl2);
        }
        boolean bl3 = bl;
        for (JMenuItem jMenuItem : this.unlockingTargets) {
            jMenuItem.setEnabled(bl3);
        }
    }

    void addActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed(Object object, Item item) {
        try {
            ActionEvent actionEvent = new ActionEvent(object, 1001, item.toString());
            for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                actionListener.actionPerformed(actionEvent);
            }
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this.getParent(), exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Item {
        NEW,
        CLOSE,
        QUIT,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL,
        FIND,
        TOGGLE_FOCUS,
        CLEAR_MESSAGE,
        STATUS_BAR,
        INFO_TREE,
        COLUMN_NUMBER,
        ALWAYS_ON_TOP,
        REFRESH,
        WIDEN_COLUMN_WIDTH,
        NARROW_COLUMN_WIDTH,
        ADJUST_COLUMN_WIDTH,
        AUTO_ADJUST_MODE,
        AUTO_ADJUST_MODE_NONE,
        AUTO_ADJUST_MODE_HEADER,
        AUTO_ADJUST_MODE_VALUE,
        AUTO_ADJUST_MODE_HEADERANDVALUE,
        EXECUTE,
        BREAK,
        HISTORY_BACK,
        HISTORY_NEXT,
        RETRIEVE_HISTORY,
        ROLLBACK,
        COMMIT,
        CONNECT,
        DISCONNECT,
        POST_PROCESS_MODE,
        POST_PROCESS_MODE_NONE,
        POST_PROCESS_MODE_FOCUS,
        POST_PROCESS_MODE_SHAKE,
        POST_PROCESS_MODE_BLINK,
        ENCRYPTION_KEY,
        EDIT_CONNECTORS,
        SORT,
        IMPORT,
        EXPORT,
        HELP,
        ABOUT;

    }
}

