/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Download
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Download.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (!parameter.has(2)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.at(1);
        String string2 = parameter.after(2);
        if (log.isDebugEnabled()) {
            log.debug("root: " + string);
            log.debug("SQL: " + string2);
        }
        try {
            Statement statement = this.prepareStatement(connection, parameter.asString());
            try {
                ResultSet resultSet = this.executeQuery(statement, string2);
                try {
                    this.download(resultSet, string);
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void download(ResultSet var1_1, String var2_2) throws IOException, SQLException {
        var4_3 = var1_1.getMetaData();
        var5_4 = var4_3.getColumnCount();
        if (!Download.$assertionsDisabled && var5_4 < 1) {
            throw new AssertionError();
        }
        var6_5 = var4_3.getColumnType(1);
        switch (var6_5) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                var7_6 = false;
                break;
            }
            case -7: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                var7_6 = false;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                var7_6 = true;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                var7_6 = true;
                break;
            }
            case 1111: {
                var7_6 = true;
                break;
            }
            default: {
                throw new CommandException(String.format("unsupported type: %d", new Object[]{var6_5}));
            }
        }
        var8_7 = new byte[var7_6 != false ? 65536 : 0];
        var9_8 = 0;
        while (var1_1.next()) {
            block25: {
                ++var9_8;
                var10_9 = new StringBuilder();
                for (var11_11 = 2; var11_11 <= var5_4; ++var11_11) {
                    var10_9.append(var1_1.getString(var11_11));
                }
                var11_10 = this.resolvePath(var2_2);
                v0 = var12_12 = var5_4 == 1 ? var11_10 : new File(var11_10, var10_9.toString());
                if (var12_12.exists()) {
                    throw new IOException(this.getMessage("e.file-already-exists", new Object[]{var12_12.getAbsolutePath()}));
                }
                if (!var7_6) ** GOTO lbl59
                var13_13 = var1_1.getBinaryStream(1);
                if (var13_13 == null) {
                    this.mkdirs(var12_12);
                    if (!var12_12.createNewFile()) {
                        throw new IOException(this.getMessage("e.failed-create-new-file", new Object[]{var12_12.getAbsolutePath()}));
                    }
                } else {
                    try {
                        this.mkdirs(var12_12);
                        var14_14 = new FileOutputStream(var12_12);
                        try {
                            while (true) {
                                if ((var15_15 = var13_13.read(var8_7)) <= 0) {
                                    break block25;
                                }
                                var14_14.write(var8_7, 0, var15_15);
                            }
                        }
                        finally {
                            var14_14.close();
                        }
                    }
                    finally {
                        var13_13.close();
                    }
lbl59:
                    // 1 sources

                    this.mkdirs(var12_12);
                    var13_13 = new PrintWriter(var12_12);
                    try {
                        var13_13.print(var1_1.getObject(1));
                    }
                    finally {
                        var13_13.close();
                    }
                }
            }
            this.outputMessage("i.downloaded", new Object[]{Download.getSizeString(var12_12.length()), var12_12});
        }
        this.outputMessage("i.selected", new Object[]{var9_8});
    }

    private void mkdirs(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("mkdir [%s]", file2.getAbsolutePath()));
            }
            if (file2.mkdirs()) {
                this.outputMessage("i.did-mkdir", file2);
            } else {
                throw new IOException(this.getMessage("e.failed-mkdir-filedir", file));
            }
        }
    }

    static String getSizeString(long l) {
        if (l >= 512L) {
            String string;
            double d;
            if (l >= 0x20000000L) {
                d = (float)l * 1.0f / 1.0737418E9f;
                string = "GB";
            } else if (l >= 524288L) {
                d = (float)l * 1.0f / 1048576.0f;
                string = "MB";
            } else {
                d = (float)l * 1.0f / 1024.0f;
                string = "KB";
            }
            return String.format("%.3f", d).replaceFirst("\\.?0+$", "") + string;
        }
        return String.format("%dbyte%s", l, l < 2L ? "" : "s");
    }
}

