/*
 *  Copyright 2012 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;
import java.text.*;
import java.util.*;
import java.util.concurrent.*;

/**
 * \[XǗB
 */
public final class ResourceManager {

    private static final Class<?> CLASS = ResourceManager.class;
    private static final ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>();

    private List<Map<String, String>> list;

    private ResourceManager(List<Map<String, String>> list) {
        this.list = list;
    }

    /**
     * CX^X̎擾B
     * @param o ohiȊȌꍇ́ApbP[W: O+"messages"A
     * NX: NX(FQCN)Ȃ: IuWFNgFQCN ꂼohƂj
     * @return CX^X
     */
    public static ResourceManager getInstance(Object o) {
        Locale loc = Locale.getDefault();
        String[] suffixes = {"_" + loc, "_" + loc.getLanguage(), ""};
        List<Map<String, String>> a = new ArrayList<Map<String, String>>();
        for (final String name : getResourceNames(o)) {
            for (final String suffix : suffixes) {
                final String key = name + suffix;
                Map<String, String> m = map.get(key);
                if (m == null) {
                    m = loadResource(key, "u8p", "utf-8");
                    if (m == null) {
                        // m = loadResourceAsProperties(key);
                        // if (m == null) {
                        continue;
                        // }
                    }
                    map.putIfAbsent(key, m);
                }
                a.add(m);
            }
        }
        return new ResourceManager(a);
    }

    private static Set<String> getResourceNames(Object o) {
        Set<String> set = new LinkedHashSet<String>();
        String cn = null;
        String pn = null;
        if (o instanceof String) {
            cn = (String)o;
        } else if (o instanceof Package) {
            pn = ((Package)o).getName();
        } else if (o != null) {
            final Class<?> c = (o instanceof Class) ? (Class<?>)o : o.getClass();
            cn = c.getName();
            pn = c.getPackage().getName();
        }
        if (cn != null) {
            set.add(cn);
        }
        if (pn != null) {
            set.add(pn + ".messages");
        }
        set.add(CLASS.getPackage().getName() + ".messages");
        return set;
    }

    private static Map<String, String> loadResource(String name, String extension, String encname) {
        final String path = "/" + name.replace('.', '/') + '.' + extension;
        InputStream is = CLASS.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        List<String> lines = new ArrayList<String>();
        Scanner r = new Scanner(is, encname);
        try {
            StringBuilder buffer = new StringBuilder();
            while (r.hasNextLine()) {
                final String s = r.nextLine();
                if (s.matches("^\\s*#.*")) {
                    continue;
                }
                buffer.append(s.replace("\\t", "\t").replace("\\n", "\n"));
                if (s.endsWith("\\")) {
                    buffer.setLength(buffer.length() - 1);
                    continue;
                }
                lines.add(buffer.toString());
                buffer.setLength(0);
            }
            if (buffer.length() > 0) {
                lines.add(buffer.toString());
            }
        } finally {
            r.close();
        }
        Map<String, String> m = new HashMap<String, String>();
        for (final String s : lines) {
            if (s.contains("=")) {
                String[] a = s.split("=", 2);
                m.put(a[0].trim(), a[1].trim().replaceFirst("\\\\$", " ").replace("\\ ", " "));
            } else {
                m.put(s.trim(), "");
            }
        }
        return m;
    }

/*
    private static Map<String, String> loadResourceAsProperties(String name) {
        final String path = "/" + name.replace('.', '/') + ".properties";
        InputStream is = CLASS.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            Map<String, String> m = new LinkedHashMap<String, String>();
            try {
                Properties props = new Properties();
                props.load(is);
                for (Entry<Object, Object> entry : props.entrySet()) {
                    m.put((String)entry.getKey(), (String)entry.getValue());
                }
            } finally {
                is.close();
            }
            return m;
        } catch (IOException ex) {
            return null;
        }
    }
 */

    private String s(String key) {
        for (final Map<String, String> m : this.list) {
            final String s = m.get(key);
            if (s != null) {
                return s;
            }
        }
        return "";
    }

    /**
     * @param key
     * @return w肵L[̗vf݂邩ǂ
     */
    public boolean containsKey(String key) {
        for (final Map<String, String> m : this.list) {
            if (m.containsKey(key)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param key
     * @param args
     * @return l
     */
    public String get(String key, Object... args) {
        final String s = s(key);
        return (s.length() == 0) ? key : MessageFormat.format(s(key), args);
    }

    /**
     * @param key
     * @return l
     */
    public boolean isTrue(String key) {
        return s(key).matches("(?i)true|on|yes");
    }

    /**
     * @param key
     * @return l
     */
    public char getChar(String key) {
        final String s = get(key);
        return (s.length() == 0) ? ' ' : s.charAt(0);
    }

    /**
     * @param key
     * @return l
     */
    public int getInt(String key) {
        return getInt(key, 0);
    }

    /**
     * @param key
     * @param defaultValue l
     * @return l
     */
    public int getInt(String key, int defaultValue) {
        final String s = get(key);
        try {
            return Integer.parseInt(s);
        } catch (NumberFormatException ex) {
            // ignore
        }
        return defaultValue;
    }

}
