/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.Resource;

final class ConsoleTextArea
extends JTextArea
implements ActionUtility.ActionCommandListener {
    private static final String cmdSubmit = "submit";
    private static final String cmdCopyOrBreak = "copy-or-break";
    private static final String cmdBreak = "break";
    private static final String cmdAddNewLine = "add-new-line";
    private static final String cmdJumpToHomePosition = "jump-to-home-position";
    private final UndoManager undoManager;
    private int homePosition;

    ConsoleTextArea() {
        ActionUtility actionUtility = ActionUtility.getInstance(this);
        this.undoManager = actionUtility.setUndoAction();
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new DocumentFilter(){

            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (ConsoleTextArea.this.isEditablePosition(n)) {
                    super.insertString(filterBypass, n, string, attributeSet);
                }
            }

            public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                if (ConsoleTextArea.this.isEditablePosition(n)) {
                    super.remove(filterBypass, n, n2);
                }
            }

            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                if (ConsoleTextArea.this.isEditablePosition(n)) {
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }
            }
        });
        int n = Resource.getMenuShortcutKeyMask();
        actionUtility.bindAction(this, cmdSubmit, KeyStroke.getKeyStroke(10, 0), KeyStroke.getKeyStroke(77, n));
        actionUtility.bindAction(this, cmdCopyOrBreak, KeyStroke.getKeyStroke(67, n));
        actionUtility.bindAction(this, cmdBreak, KeyStroke.getKeyStroke(66, 512));
        actionUtility.bindAction(this, cmdAddNewLine, KeyStroke.getKeyStroke(10, n));
        actionUtility.bindAction(this, cmdJumpToHomePosition, KeyStroke.getKeyStroke(36, 0));
    }

    public void actionCommandPerform(ActionEvent actionEvent, String string) {
        if (string.equals(cmdSubmit)) {
            int n;
            int n2 = this.getCaretPosition();
            if (n2 != (n = this.getEndPosition())) {
                this.setCaretPosition(n);
                return;
            }
            this.fireActionPerformed();
        } else if (string.equals(cmdCopyOrBreak)) {
            if (this.getSelectedText() == null) {
                this.sendBreak();
            } else {
                DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
                copyAction.actionPerformed(actionEvent);
            }
        } else if (string.equals(cmdBreak)) {
            this.sendBreak();
        } else if (string.equals(cmdAddNewLine)) {
            this.insert("\n", this.getCaretPosition());
        } else if (string.equals(cmdJumpToHomePosition)) {
            this.setCaretPosition(this.getHomePosition());
        }
    }

    void addActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        assert (actionListener != null);
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, this.getEditableText());
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    boolean canUndo() {
        return this.undoManager.canUndo();
    }

    boolean canRedo() {
        return this.undoManager.canRedo();
    }

    void append(String string, boolean bl) {
        super.append(string);
        if (bl) {
            this.setCaretPosition(this.getEndPosition());
        }
    }

    void output(String string) {
        super.append(string);
        this.undoManager.discardAllEdits();
        this.homePosition = this.getEndPosition();
        this.setCaretPosition(this.homePosition);
    }

    void replace(String string) {
        this.replaceRange(string, this.homePosition, this.getEndPosition());
    }

    void clear() {
        this.homePosition = 0;
        this.setText("");
    }

    String getEditableText() {
        try {
            return this.getText(this.homePosition, this.getEndPosition() - this.homePosition);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    boolean isEditablePosition(int n) {
        return n >= this.homePosition;
    }

    int getHomePosition() {
        return this.homePosition;
    }

    int getEndPosition() {
        Document document = this.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    void resetHomePosition() {
        this.undoManager.discardAllEdits();
        this.homePosition = this.getEndPosition();
    }

    void sendBreak() {
        this.append(Resource.getString("ConsoleTextArea.breakprompt", new Object[0]));
        this.resetHomePosition();
        this.validate();
    }

    public void updateUI() {
        if (this.getCaret() == null) {
            super.updateUI();
        } else {
            int n = this.getCaretPosition();
            super.updateUI();
            this.setCaretPosition(n);
        }
    }
}

