/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.console;

import java.util.*;

import net.argius.stew.*;

/**
 * \[XB
 */
final class Resource {

    /** 󕶎 */
    static final String EMPTY_STRING = "";

    private static final String BUNDLE_NAME = Resource.class.getPackage().getName() + ".messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    private Resource() {
        // empty
    }

    /**
     * O̎擾B
     * @param key L[
     * @param args p[^
     * @return 
     */
    static String getString(String key, Object... args) {
        return LocalSystem.getBundleMessage(RESOURCE_BUNDLE, key, args);
    }

    /**
     * o[W̎擾B
     * @return o[W
     */
    static String getVersion() {
        return LocalSystem.getVersion();
    }

}
