/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;
import java.nio.channels.*;
import java.util.*;
import java.util.regex.*;

/**
 * RlN^ݒB
 */
public final class ConnectorConfiguration {

    // IDp^[ : namevpeB擾
    private static final Pattern idPattern = Pattern.compile("^([^\\.]+)\\.name *=");

    /**
     * RlN^ݒǂݍށB
     * @return RlN^ݒ}bv
     * @throws IOException
     */
    public static ConnectorMap load() throws IOException {
        InputStream is = new FileInputStream(getPath());
        try {
            return load(is);
        } finally {
            is.close();
        }
    }

    /**
     * RlN^ݒǂݍށB
     * @param is ̓Xg[
     * @return RlN^ݒ}bv
     * @throws IOException
     */
    public static ConnectorMap load(InputStream is) throws IOException {
        // ēxgp邽߃LbV
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        for (int c; (c = is.read(buffer)) >= 0;) {
            bos.write(buffer, 0, c);
        }
        bos.flush();
        // IDXg쐬
        List<String> idList = new ArrayList<String>();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
        try {
            for (String line; (line = reader.readLine()) != null;) {
                Matcher matcher = idPattern.matcher(line);
                if (matcher.find()) {
                    idList.add(matcher.group(1));
                }
            }
        } finally {
            reader.close();
        }
        // vpeBƂēǂݍ
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(bos.toByteArray()));
        // 
        return new ConnectorMap(idList, props);
    }

    /**
     * RlN^ݒۑB
     * @param map RlN^ݒ}bv
     * @throws IOException
     */
    public static void save(ConnectorMap map) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        save(bos, map);
        byte[] bytes = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        FileOutputStream fos = new FileOutputStream(getPath());
        try {
            fos.getChannel().transferFrom(Channels.newChannel(bis), 0, bytes.length);
        } finally {
            fos.close();
        }
    }

    /**
     * RlN^ݒۑB
     * @param os o̓Xg[
     * @param map RlN^ݒ}bv
     * @throws IOException
     */
    public static void save(OutputStream os, ConnectorMap map) throws IOException {
        // storeňxi[
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        map.toProperties().store(bos, "");
        // 1s1vfƂListɋlߑւ
        List<String> lines = new ArrayList<String>();
        Scanner scanner = new Scanner(new ByteArrayInputStream(bos.toByteArray()));
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.trim().startsWith("#")) {
                    lines.add(line);
                }
            }
        } finally {
            scanner.close();
        }
        // IDɏo
        Comparator<String> c = new ConnectorPropertyComparator(new ArrayList<String>(map.keySet()));
        Collections.sort(lines, c);
        PrintWriter out = new PrintWriter(os);
        try {
            for (String line : lines) {
                out.println(line);
            }
            out.flush();
        } finally {
            out.close();
        }
    }

    /**
     * pX̎擾B
     * @return pX
     */
    private static File getPath() {
        return new File(LocalSystem.getDirectory(), Environment.CONNECTOR_PROPERTIES_NAME);
    }

    /**
     * ڑvpeB̏tsr֐B
     */
    private static final class ConnectorPropertyComparator implements
                                                          Comparator<String>,
                                                          Serializable {

        /**
         * <code>serialVersionUID</code>
         */
        private static final long serialVersionUID = 1803584843826843857L;

        private final List<String> idList;

        ConnectorPropertyComparator(List<String> idList) {
            this.idList = idList;
        }

        public int compare(String s1, String s2) {
            int index1 = getIdIndex(s1);
            int index2 = getIdIndex(s2);
            if (index1 == index2) {
                return s1.compareTo(s2);
            }
            return index1 - index2;
        }

        /**
         * ID̃CfbNX擾B
         * @param s vpeB1s̕
         * @return CfbNX
         */
        private int getIdIndex(String s) {
            String[] sa = s.split("\\.", 2);
            if (sa.length >= 2) {
                String id = sa[0];
                return idList.indexOf(id);
            }
            return -1;
        }

    }

}