/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Environment;
import net.argius.stew.ui.window.ConnectorEditDialog;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.FlexiblePanel;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ConnectorMapEditDialog
extends JDialog
implements ChangeListener {
    private final ConnectorMap connectorMap;
    private final JList idList;
    private final DefaultListModel listModel;

    ConnectorMapEditDialog(JFrame jFrame, Environment environment) {
        super(jFrame);
        DefaultListModel<ConnectorEntry> defaultListModel = new DefaultListModel<ConnectorEntry>();
        this.connectorMap = new ConnectorMap(environment.getConnectorMap());
        this.idList = new JList(defaultListModel);
        this.listModel = defaultListModel;
        this.setTitle(ConnectorMapEditDialog.getMessage("title"));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        FlexiblePanel flexiblePanel = new FlexiblePanel();
        flexiblePanel.c.anchor = 10;
        flexiblePanel.c.insets = new Insets(8, 12, 8, 0);
        this.add(flexiblePanel);
        final ConnectorMapEditDialog connectorMapEditDialog = this;
        final ConnectorMap connectorMap = this.connectorMap;
        final JList jList = this.idList;
        jList.setSelectionMode(0);
        for (ConnectorEntry object2 : ConnectorEntry.toList(connectorMap.values())) {
            defaultListModel.addElement(object2);
        }
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setWheelScrollingEnabled(true);
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n % 2 == 0) {
                    ConnectorEntry connectorEntry = (ConnectorEntry)jList.getSelectedValue();
                    ConnectorMapEditDialog.this.openConnectorEditDialog(connectorEntry.getConnector());
                }
            }
        });
        flexiblePanel.addComponent(jScrollPane, false);
        JPanel jPanel = new JPanel(new GridLayout(6, 1, 4, 2));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.addnew")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(connectorMapEditDialog, (Object)Resource.getString("i.input-new-connector-id", new Object[0]));
                if (string == null) {
                    return;
                }
                try {
                    if (connectorMap.containsKey(string)) {
                        String string2 = Resource.getString("e.id-already-exists", string);
                        JOptionPane.showMessageDialog(connectorMapEditDialog, string2, null, 0);
                    } else {
                        ConnectorMapEditDialog.this.openConnectorEditDialog(new Connector(string, new Properties()));
                    }
                }
                catch (Exception exception) {
                    WindowOutputProcessor.showErrorDialog(connectorMapEditDialog, exception);
                }
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.modify")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorEntry connectorEntry = (ConnectorEntry)jList.getSelectedValue();
                if (connectorEntry != null) {
                    ConnectorMapEditDialog.this.openConnectorEditDialog(connectorEntry.getConnector());
                }
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.rename")){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e = jList.getSelectedValue();
                if (e == null) {
                    return;
                }
                ConnectorEntry connectorEntry = (ConnectorEntry)e;
                String string = JOptionPane.showInputDialog(connectorMapEditDialog, Resource.getString("i.input-new-connector-id", new Object[0]), connectorEntry.getId());
                if (string == null) {
                    return;
                }
                if (string.equals(connectorEntry.getId())) {
                    return;
                }
                connectorMap.remove(connectorEntry);
                connectorMap.put(string, connectorEntry.getConnector());
                DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                Connector connector = new Connector(string, connectorEntry.getConnector());
                defaultListModel.set(defaultListModel.indexOf(connectorEntry), new ConnectorEntry(string, connector));
                jList.repaint();
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.remove")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(connectorMapEditDialog, Resource.getString("i.confirm-remove", new Object[0]), "", 2) != 0) {
                    return;
                }
                ConnectorEntry connectorEntry = (ConnectorEntry)jList.getSelectedValue();
                connectorMap.remove(connectorEntry.getId());
                DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                defaultListModel.removeElement(connectorEntry);
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.up")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.shiftSelectedElementUpward();
            }
        }));
        jPanel.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.down")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.shiftSelectedElementDownward();
            }
        }));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.insets = new Insets(8, 32, 8, 32);
        flexiblePanel.addComponent(jPanel, true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 16, 8));
        jPanel2.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.submit")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.requestClose(true);
            }
        }));
        jPanel2.add(new JButton(new AbstractAction(ConnectorMapEditDialog.getMessage("button.cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.requestClose(false);
            }
        }));
        flexiblePanel.c.gridwidth = 0;
        flexiblePanel.c.fill = 0;
        flexiblePanel.addComponent(jPanel2, false);
        this.getRootPane().getActionMap().put("cancel-and-close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.requestClose(false);
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel-and-close");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConnectorMapEditDialog.this.requestClose(false);
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Connector) {
            Connector connector = (Connector)object;
            String string = connector.getId();
            this.connectorMap.setConnector(string, connector);
            ConnectorEntry connectorEntry = new ConnectorEntry(string, connector);
            int n = this.listModel.indexOf(connectorEntry);
            if (n >= 0) {
                this.listModel.set(n, connectorEntry);
                this.idList.setSelectedIndex(n);
            } else {
                this.listModel.add(0, connectorEntry);
                this.idList.setSelectedIndex(0);
            }
        }
    }

    void openConnectorEditDialog(Connector connector) {
        ConnectorEditDialog connectorEditDialog = new ConnectorEditDialog(this, connector);
        connectorEditDialog.addChangeListener(this);
        connectorEditDialog.setModal(true);
        connectorEditDialog.setLocationRelativeTo(this.getParent());
        connectorEditDialog.setSize(connectorEditDialog.getPreferredSize());
        connectorEditDialog.setVisible(true);
    }

    void shiftSelectedElementUpward() {
        int n = this.idList.getSelectedIndex();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        ConnectorMapEditDialog.swap(this.listModel, n, n2);
        this.idList.setSelectedIndex(n2);
        this.idList.ensureIndexIsVisible(n2);
    }

    void shiftSelectedElementDownward() {
        int n;
        int n2 = this.idList.getSelectedIndex();
        if (n2 == (n = this.listModel.getSize()) - 1) {
            return;
        }
        int n3 = n2 + 1;
        ConnectorMapEditDialog.swap(this.listModel, n2, n3);
        this.idList.setSelectedIndex(n3);
        this.idList.ensureIndexIsVisible(n3);
    }

    private static void swap(DefaultListModel defaultListModel, int n, int n2) {
        Object e = defaultListModel.get(n);
        defaultListModel.set(n, defaultListModel.get(n2));
        defaultListModel.set(n2, e);
    }

    void requestClose(boolean bl) {
        if (bl) {
            if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-save", new Object[0]), "", 0) != 0) {
                return;
            }
            ConnectorMap connectorMap = new ConnectorMap();
            for (Object object : this.listModel.toArray()) {
                ConnectorEntry connectorEntry = (ConnectorEntry)object;
                String string = connectorEntry.getId();
                connectorMap.setConnector(string, this.connectorMap.getConnector(string));
            }
            try {
                ConnectorConfiguration.save(connectorMap);
                this.connectorMap.clear();
                this.connectorMap.putAll(connectorMap);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
            }
        } else if (JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-without-save", new Object[0]), "", 2) != 0) {
            return;
        }
        this.dispose();
    }

    private static String getMessage(String string) {
        return Resource.getString("ConnectorMapEditDialog." + string, new Object[0]);
    }
}

