/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Download
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Download.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (!parameter.has(2)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.at(1);
        String string2 = parameter.after(2);
        if (log.isDebugEnabled()) {
            log.debug("root: " + string);
            log.debug("SQL: " + string2);
        }
        try {
            Statement statement = this.prepareStatement(connection, parameter.asString());
            try {
                ResultSet resultSet = this.executeQuery(statement, string2);
                try {
                    this.download(resultSet, string);
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void download(ResultSet resultSet, String string) throws IOException, SQLException {
        boolean bl;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        assert (n >= 1);
        int n2 = resultSetMetaData.getColumnType(1);
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = false;
                break;
            }
            case -7: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                bl = false;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bl = true;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                bl = true;
                break;
            }
            case 1111: {
                bl = true;
                break;
            }
            default: {
                throw new CommandException(String.format("unsupported type: %d", n2));
            }
        }
        int n3 = 0;
        while (true) {
            File file;
            block24: {
                Closeable closeable;
                block25: {
                    if (!resultSet.next()) {
                        this.outputMessage("i.selected", n3);
                        return;
                    }
                    ++n3;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 2; i <= n; ++i) {
                        stringBuilder.append(resultSet.getString(i));
                    }
                    File file2 = this.resolvePath(string);
                    File file3 = file = n == 1 ? file2 : new File(file2, stringBuilder.toString());
                    if (file.exists()) {
                        throw new IOException(this.getMessage("e.file-already-exists", file.getAbsolutePath()));
                    }
                    if (!bl) break block25;
                    closeable = resultSet.getBinaryStream(1);
                    if (closeable == null) {
                        this.mkdirs(file);
                        if (!file.createNewFile()) {
                            throw new IOException(this.getMessage("e.failed-create-new-file", file.getAbsolutePath()));
                        }
                        break block24;
                    } else {
                        try {
                            this.mkdirs(file);
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            try {
                                ReadableByteChannel readableByteChannel = Channels.newChannel((InputStream)closeable);
                                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                                break block24;
                            }
                            finally {
                                fileOutputStream.close();
                            }
                        }
                        finally {
                            ((InputStream)closeable).close();
                        }
                    }
                }
                this.mkdirs(file);
                closeable = new PrintWriter(file);
                try {
                    ((PrintWriter)closeable).print(resultSet.getObject(1));
                }
                finally {
                    ((PrintWriter)closeable).close();
                }
            }
            this.outputMessage("i.downloaded", Download.getSizeString(file.length()), file);
        }
    }

    private void mkdirs(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("mkdir [%s]", file2.getAbsolutePath()));
            }
            if (file2.mkdirs()) {
                this.outputMessage("i.did-mkdir", file2);
            } else {
                throw new IOException(this.getMessage("e.failed-mkdir-filedir", file));
            }
        }
    }

    static String getSizeString(long l) {
        if (l >= 512L) {
            String string;
            double d;
            if (l >= 0x20000000L) {
                d = (float)l * 1.0f / 1.0737418E9f;
                string = "GB";
            } else if (l >= 524288L) {
                d = (float)l * 1.0f / 1048576.0f;
                string = "MB";
            } else {
                d = (float)l * 1.0f / 1024.0f;
                string = "KB";
            }
            return String.format("%.3f", d).replaceFirst("\\.?0+$", "") + string;
        }
        return String.format("%dbyte%s", l, l < 2L ? "" : "s");
    }
}

