/*
 * Decompiled with CFR 0.152.
 */
package net.argius.logging;

import net.argius.logging.Logger;

public abstract class BasicLogger
implements Logger {
    private boolean isInfoEnabled;
    private boolean isDebugEnabled;
    private boolean isTraceEnabled;

    protected BasicLogger() {
    }

    protected abstract void printMessage(String var1, Object var2);

    protected abstract void printStackTrace(Throwable var1);

    protected static int getLineNumber(String string) {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                if (stackTraceElement == null || !string.equals(stackTraceElement.getClassName())) continue;
                return stackTraceElement.getLineNumber();
            }
            return -1;
        }
    }

    public void setLevel(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("INFO")) {
            this.isInfoEnabled = true;
            this.isDebugEnabled = false;
            this.isTraceEnabled = false;
        } else if (string.equalsIgnoreCase("DEBUG")) {
            this.isInfoEnabled = true;
            this.isDebugEnabled = true;
            this.isTraceEnabled = false;
        } else if (string.equalsIgnoreCase("TRACE")) {
            this.isInfoEnabled = true;
            this.isDebugEnabled = true;
            this.isTraceEnabled = true;
        }
    }

    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public void fatal(Object object, Throwable throwable) {
        this.fatal(object);
        this.printStackTrace(throwable);
    }

    public void fatal(Object object) {
        this.printMessage("FATAL", object);
    }

    public void error(Object object, Throwable throwable) {
        this.error(object);
        this.printStackTrace(throwable);
    }

    public void error(Object object) {
        this.printMessage("ERROR", object);
    }

    public void warn(Object object, Throwable throwable) {
        this.warn(object);
        this.printStackTrace(throwable);
    }

    public void warn(Object object) {
        this.printMessage("WARN", object);
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.info(object);
            this.printStackTrace(throwable);
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.printMessage("INFO ", object);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.debug(object);
            this.printStackTrace(throwable);
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.printMessage("DEBUG", object);
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.trace(object);
            this.printStackTrace(throwable);
        }
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.printMessage("TRACE", object);
        }
    }
}

