/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * f[^x[Xe[ȕ\R}hB
 */
public final class Report extends Command {

    private static final Logger log = LoggerFactory.getLogger(Report.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(getUsage());
        }
        // Es
        try {
            final String p1 = parameter.get(2);
            if (p1.equals("-")) {
                reportDBInfo(conn);
            } else {
                final DatabaseMetaData dbmeta = conn.getMetaData();
                final String tableName = p1;
                final String cmd = parameter.asString();
                final String p2 = parameter.get(3);
                if (p2.equalsIgnoreCase("PK")) {
                    reportPrimaryKeyInfo(dbmeta, tableName, cmd);
                } else if (p2.equalsIgnoreCase("INDEX")) {
                    reportIndexInfo(dbmeta, tableName, cmd);
                } else {
                    reportTableDescription(dbmeta, tableName, cmd);
                }
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    /**
     * e[u`\B
     * @param dbmeta DB^f[^
     * @param tableName e[u
     * @param cmd R}h
     * @throws SQLException
     */
    private void reportTableDescription(DatabaseMetaData dbmeta, String tableName, String cmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + tableName);
        }
        ResultSet rs = dbmeta.getColumns(null, null, convertPattern(tableName), null);
        try {
            ResultSetReference ref = new ResultSetReference(rs, cmd);
            ColumnOrder order = ref.getOrder();
            order.addOrder(17, getColumnName("sequence"));
            order.addOrder(4, getColumnName("columnname"));
            order.addOrder(18, getColumnName("nullable"));
            order.addOrder(6, getColumnName("type"));
            order.addOrder(7, getColumnName("size"));
            order.addOrder(2, getColumnName("schema"));
            output(ref);
            outputMessage("i.selected", ref.getRecordCount());
        } finally {
            rs.close();
        }
    }

    /**
     * vC}L[\B
     * @param dbmeta DB^f[^
     * @param tableName e[u
     * @param cmd R}h
     * @throws SQLException
     */
    private void reportPrimaryKeyInfo(DatabaseMetaData dbmeta, String tableName, String cmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + tableName);
        }
        ResultSet rs = dbmeta.getPrimaryKeys(null, null, convertPattern(tableName));
        try {
            ResultSetReference ref = new ResultSetReference(rs, cmd);
            ColumnOrder order = ref.getOrder();
            order.addOrder(1, getColumnName("catalog"));
            order.addOrder(2, getColumnName("schema"));
            order.addOrder(3, getColumnName("tablename"));
            order.addOrder(5, getColumnName("sequence"));
            order.addOrder(4, getColumnName("columnname"));
            order.addOrder(6, getColumnName("keyname"));
            output(ref);
            outputMessage("i.selected", ref.getRecordCount());
        } finally {
            rs.close();
        }
    }

    /**
     * CfbNX\B
     * @param dbmeta DB^f[^
     * @param tableName e[u
     * @param cmd R}h
     * @throws SQLException
     */
    private void reportIndexInfo(DatabaseMetaData dbmeta, String tableName, String cmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + tableName);
        }
        ResultSet rs = dbmeta.getIndexInfo(null, null, convertPattern(tableName), false, false);
        try {
            ResultSetReference ref = new ResultSetReference(rs, cmd);
            ColumnOrder order = ref.getOrder();
            order.addOrder(1, getColumnName("catalog"));
            order.addOrder(2, getColumnName("schema"));
            order.addOrder(3, getColumnName("tablename"));
            order.addOrder(8, getColumnName("sequence"));
            order.addOrder(9, getColumnName("columnname"));
            order.addOrder(6, getColumnName("keyname"));
            output(ref);
            outputMessage("i.selected", ref.getRecordCount());
        } finally {
            rs.close();
        }
    }

    /**
     * f[^x[X\B
     * @param conn RlNV
     * @throws SQLException
     */
    private void reportDBInfo(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData meta = conn.getMetaData();
        outputMessage("Report.dbinfo",
                      meta.getDatabaseProductName(),
                      meta.getDatabaseProductVersion(),
                      meta.getDriverName(),
                      meta.getDriverVersion(),
                      meta.getUserName(),
                      meta.getURL());
    }

    private String getColumnName(String key) {
        return getMessage("Report.label." + key);
    }

}
