/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.console;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Parameter;
import net.argius.stew.ui.console.Resource;

public final class ConnectorMapEditor {
    private static final String[] PROP_KEYS = new String[]{"name", "classpath", "driver", "url", "user", "password", "readonly", "rollback"};
    private final ConnectorMap map;
    private ConnectorMap oldContent;

    private ConnectorMapEditor() throws IOException {
        ConnectorMap connectorMap;
        try {
            connectorMap = ConnectorConfiguration.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ConnectorMapEditor.printMessage("main.notice.filenotexists", new Object[0]);
            ConnectorMapEditor.printLine(String.format("(%s)", fileNotFoundException.getMessage()));
            connectorMap = new ConnectorMap();
        }
        this.oldContent = connectorMap;
        this.map = new ConnectorMap(this.oldContent);
    }

    private boolean proceedInputProperties(String string, Properties properties) {
        do {
            ConnectorMapEditor.printMessage("property.start1", new Object[0]);
            ConnectorMapEditor.printMessage("property.start2", new Object[0]);
            for (String string2 : PROP_KEYS) {
                String string3 = properties.getProperty(string2);
                ConnectorMapEditor.print(ConnectorMapEditor.getString("property.input", string2, string3));
                String string4 = ConnectorMapEditor.getInput("", new Object[0]);
                if (string4 == null || string4.length() <= 0) continue;
                properties.setProperty(string2, string4);
            }
            for (String string2 : PROP_KEYS) {
                ConnectorMapEditor.printLine(string2 + "=" + properties.getProperty(string2));
            }
            if (ConnectorMapEditor.confirmYes("property.tryconnect.confirm")) {
                try {
                    Connector connector = new Connector(string, properties);
                    connector.getConnection();
                    ConnectorMapEditor.printMessage("property.tryconnect.succeeded", new Object[0]);
                }
                catch (SQLException sQLException) {
                    ConnectorMapEditor.printMessage("property.tryconnect.failed", sQLException.getMessage());
                }
            }
            if (!ConnectorMapEditor.confirmYes("property.update.confirm")) continue;
            return true;
        } while (ConnectorMapEditor.confirmYes("property.retry.confirm"));
        ConnectorMapEditor.printMessage("property.update.cancel", new Object[0]);
        return false;
    }

    private void proceedAdd(String string) {
        if (this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.alreadyexists", string);
            return;
        }
        Properties properties = new Properties();
        for (String string2 : PROP_KEYS) {
            properties.setProperty(string2, "");
        }
        if (this.proceedInputProperties(string, properties)) {
            this.map.put(string, new Connector(string, properties));
            ConnectorMapEditor.printMessage("proc.added", string);
        }
    }

    private void proceedModify(String string) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            return;
        }
        Properties properties = this.map.getConnector(string).toProperties();
        if (this.proceedInputProperties(string, properties)) {
            this.map.put(string, new Connector(string, properties));
            ConnectorMapEditor.printMessage("proc.modified", string);
        }
    }

    private void proceedRemove(String string) {
        Connector connector = this.map.getConnector(string);
        ConnectorMapEditor.printLine("ID[" + string + "]:" + connector.getName());
        if (ConnectorMapEditor.confirmYes("proc.remove.confirm")) {
            this.map.remove(string);
            ConnectorMapEditor.printMessage("proc.remove.finished", new Object[0]);
        } else {
            ConnectorMapEditor.printMessage("proc.remove.canceled", new Object[0]);
        }
        ConnectorMapEditor.printLine(this.map);
    }

    private void proceedCopy(String string, String string2) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            ConnectorMapEditor.printMessage("proc.copy.canceled", new Object[0]);
            return;
        }
        if (this.map.containsKey(string2)) {
            ConnectorMapEditor.printMessage("proc.alreadyexists", string2);
            ConnectorMapEditor.printMessage("proc.copy.canceled", new Object[0]);
            return;
        }
        this.map.put(string2, new Connector(string2, this.map.getConnector(string)));
        ConnectorMapEditor.printMessage("proc.copy.finished", new Object[0]);
    }

    private void proceedDisplayIds() {
        for (Map.Entry entry : this.map.entrySet()) {
            String string = (String)entry.getKey();
            ConnectorMapEditor.printLine(String.format("%10s : %s", string, this.map.getConnector(string).getName()));
        }
    }

    private void proceedDisplayDetail(String string) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            return;
        }
        Properties properties = this.map.getConnector(string).toProperties();
        for (String string2 : PROP_KEYS) {
            ConnectorMapEditor.printLine(String.format("%10s : %s", string2, properties.getProperty(string2)));
        }
    }

    private void proceedSave() throws IOException {
        if (this.map.equals(this.oldContent)) {
            ConnectorMapEditor.printMessage("proc.nomodification", new Object[0]);
        } else if (ConnectorMapEditor.confirmYes("proc.save.confirm")) {
            ConnectorConfiguration.save(this.map);
            this.oldContent = new ConnectorMap(this.map);
            ConnectorMapEditor.printMessage("proc.save.finished", new Object[0]);
        } else {
            ConnectorMapEditor.printMessage("proc.save.canceled", new Object[0]);
        }
    }

    private void proceedLoad() throws IOException {
        ConnectorMap connectorMap = ConnectorConfiguration.load();
        if (connectorMap.equals(this.oldContent) && connectorMap.equals(this.map)) {
            ConnectorMapEditor.printMessage("proc.nomodification", new Object[0]);
            return;
        }
        ConnectorMapEditor.printMessage("proc.load.confirm1", new Object[0]);
        if (ConnectorMapEditor.confirmYes("proc.load.confirm2")) {
            this.map.clear();
            this.map.putAll(ConnectorConfiguration.load());
            ConnectorMapEditor.printMessage("proc.load.finished", new Object[0]);
        } else {
            ConnectorMapEditor.printMessage("proc.load.canceled", new Object[0]);
        }
    }

    private static String getInput(String string, Object ... objectArray) {
        if (string.length() > 0) {
            ConnectorMapEditor.print(ConnectorMapEditor.getString(string, objectArray));
        }
        ConnectorMapEditor.print(ConnectorMapEditor.getString("proc.prompt", new Object[0]));
        Scanner scanner = new Scanner(System.in);
        if (scanner.hasNextLine()) {
            return scanner.nextLine();
        }
        return "";
    }

    private static boolean confirmYes(String string) {
        if (string.length() > 0) {
            ConnectorMapEditor.print(ConnectorMapEditor.getString(string, new Object[0]));
        }
        ConnectorMapEditor.print("(y/N)");
        return ConnectorMapEditor.getInput("", new Object[0]).equalsIgnoreCase("y");
    }

    private static void print(Object object) {
        System.out.print(object);
    }

    private static void printLine() {
        System.out.println();
    }

    private static void printLine(Object object) {
        System.out.println(object);
    }

    private static void printMessage(String string, Object ... objectArray) {
        ConnectorMapEditor.printLine(ConnectorMapEditor.getString(string, objectArray));
    }

    private static String getString(String string, Object ... objectArray) {
        return Resource.getString("ConnectorMapEditor." + string, objectArray);
    }

    static void invoke() {
        ConnectorMapEditor.printLine();
        ConnectorMapEditor.printMessage("main.start", new Object[0]);
        ConnectorMapEditor.printLine();
        try {
            ConnectorMapEditor connectorMapEditor = new ConnectorMapEditor();
            while (true) {
                Parameter parameter = new Parameter(ConnectorMapEditor.getInput("main.wait", new Object[0]));
                String string = parameter.get(1);
                String string2 = parameter.get(2);
                if (string.equalsIgnoreCase("help")) {
                    ConnectorMapEditor.printMessage("help", new Object[0]);
                } else if (string.equalsIgnoreCase("a")) {
                    connectorMapEditor.proceedAdd(string2);
                } else if (string.equalsIgnoreCase("m")) {
                    connectorMapEditor.proceedModify(string2);
                } else if (string.equalsIgnoreCase("r")) {
                    connectorMapEditor.proceedRemove(string2);
                } else if (string.equalsIgnoreCase("copy")) {
                    connectorMapEditor.proceedCopy(string2, parameter.get(3));
                } else if (string.equalsIgnoreCase("disp")) {
                    if (string2.length() == 0) {
                        connectorMapEditor.proceedDisplayIds();
                    } else {
                        connectorMapEditor.proceedDisplayDetail(string2);
                    }
                } else if (string.equalsIgnoreCase("save")) {
                    connectorMapEditor.proceedSave();
                } else if (string.equalsIgnoreCase("load")) {
                    connectorMapEditor.proceedLoad();
                } else if (string.equalsIgnoreCase("exit") && (connectorMapEditor.map.equals(connectorMapEditor.oldContent) || ConnectorMapEditor.confirmYes("proc.exit.confirm"))) break;
                ConnectorMapEditor.printLine();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ConnectorMapEditor.printLine();
        ConnectorMapEditor.printMessage("main.end", new Object[0]);
    }

    public static void main(String ... stringArray) {
        ConnectorMapEditor.printLine(Resource.getString("i.about", Resource.getVersion()));
        ConnectorMapEditor.invoke();
    }
}

