/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import static java.awt.event.KeyEvent.*;
import static javax.swing.KeyStroke.getKeyStroke;
import static net.argius.stew.ui.window.Resource.getString;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.undo.*;

/**
 * ANṼ[eBeBB
 * R|[lg̃ANVĂȕ։B
 */
final class ActionUtility {

    private final JComponent c;
    private final ActionMap amap;
    private final InputMap imap;

    private ActionUtility(JComponent c) {
        this.c = c;
        this.amap = c.getActionMap();
        this.imap = c.getInputMap();
    }

    /**
     * CX^X̎擾B
     * @param c ΏۃR|[lg
     * @return CX^X
     */
    static ActionUtility getInstance(JComponent c) {
        return new ActionUtility(c);
    }

    /**
     * ANV蓖ĂB
     * @param action ANV
     * @return ANVL[
     */
    Object bindAction(Action action) {
        return bindAction(action, action.getValue(Action.NAME), null);
    }

    /**
     * ANV蓖ĂB
     * @param action ANV
     * @param actionKey ANVL[
     * @return ANVL[
     */
    Object bindAction(Action action, Object actionKey) {
        return bindAction(action, actionKey, null);
    }

    /**
     * ANV蓖ĂB
     * @param action ANV
     * @param actionKey ANVL[
     * @param keyStroke V[gJbgL[
     * @return ANVL[
     */
    Object bindAction(Action action, KeyStroke keyStroke) {
        return bindAction(action, action.getValue(Action.NAME), keyStroke);
    }

    /**
     * ANV蓖ĂB
     * @param action ANV
     * @param actionKey ANVL[
     * @param keyStroke V[gJbgL[
     * @return ANVL[
     */
    Object bindAction(Action action, Object actionKey, KeyStroke keyStroke) {
        amap.put(actionKey, action);
        imap.put(keyStroke, actionKey);
        return actionKey;
    }

    /**
     * ̃R|[lg̃ANVƃV[gJbgJMenuItemɃRs[B
     * @param actionKey ANVL[
     * @param dst Rs[JMenuItem
     * @return dstƓIuWFNg
     */
    JMenuItem copyActionTo(Object actionKey, JMenuItem dst) {
        final JComponent c = this.c;
        final Action action = amap.get(actionKey);
        if (action != null) {
            dst.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    e.setSource(c);
                    action.actionPerformed(e);
                }

            });
        }
        for (KeyStroke keyStroke : imap.allKeys()) {
            Object k = imap.get(keyStroke);
            if (k != null && k.equals(actionKey)) {
                dst.setAccelerator(keyStroke);
                break;
            }
        }
        return dst;
    }

    /**
     * ReLXgj[ANVXg琶Đݒ肷B
     * @param actionNames ANṼXg
     */
    void setContextMenu(String[] actionNames) {
        setContextMenu(actionNames, null);
    }

    /**
     * ReLXgj[ANVXg琶Đݒ肷B
     * @param actionNames ANṼXg
     * @param mnemonics j[jbN
     */
    void setContextMenu(String[] actionNames, char[] mnemonics) {
        c.setComponentPopupMenu(createPopupMenu(actionNames, mnemonics));
    }

    /**
     * ReLXgj[𐶐B
     * @param actionNames ANṼXg
     * @param mnemonics j[jbN
     * @return ReLXgj[
     */
    JPopupMenu createPopupMenu(String[] actionNames, char[] mnemonics) {
        JPopupMenu pmenu = new JPopupMenu();
        int index = -1;
        for (final String keyword : actionNames) {
            ++index;
            if (keyword == null || keyword.length() == 0) {
                pmenu.addSeparator();
            } else {
                char mnemonic = (mnemonics == null) ? ' ' : mnemonics[index];
                JMenuItem item = new JMenuItem(getString("Action." + keyword, mnemonic));
                item.setMnemonic(mnemonic);
                pmenu.add(copyActionTo(keyword, item));
            }
        }
        return pmenu;
    }

    /**
     * AhDEhDANVݒ肷B
     * @return UndoManager
     */
    UndoManager setUndoAction() {
        if (!(c instanceof JTextComponent)) {
            throw new IllegalComponentStateException(c.getClass().getName());
        }
        JTextComponent text = (JTextComponent)c;
        final UndoManager um = new UndoManager();
        text.getDocument().addUndoableEditListener(um);
        ActionMap amap = text.getActionMap();
        InputMap imap = text.getInputMap();
        final int shortcutKey = Resource.getMenuShortcutKeyMask();
        amap.put("undo", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                if (um.canUndo()) {
                    um.undo();
                }
            }

        });
        imap.put(getKeyStroke(VK_Z, shortcutKey), "undo");
        amap.put("redo", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                if (um.canRedo()) {
                    um.redo();
                }
            }

        });
        imap.put(getKeyStroke(VK_Y, shortcutKey), "redo");
        return um;
    }

    /**
     * AhDEhDANVݒ肷B
     * @param c Ώ
     * @return UndoManager
     */
    static UndoManager setUndoAction(JTextComponent c) {
        return new ActionUtility(c).setUndoAction();
    }

    /**
     * eLXgR|[lg̃ANVݒ肷B
     */
    void setActionForTextComponent() {
        if (!(c instanceof JTextComponent)) {
            throw new IllegalComponentStateException(c.getClass().getName());
        }
        final JTextComponent text = (JTextComponent)c;
        final UndoManager um = setUndoAction();
        final JPopupMenu pmenu = new JPopupMenu();
        final Map<String, JMenuItem> m = new HashMap<String, JMenuItem>();
        int index = 0;
        char[] mnemonics = "URTCPA".toCharArray();
        for (String actionName : new String[]{"undo", "redo", "", "cut-to-clipboard",
                                              "copy-to-clipboard", "paste-from-clipboard",
                                              "select-all",}) {
            if (actionName.length() == 0) {
                pmenu.addSeparator();
            } else {
                final char mnemonic = mnemonics[index++];
                final JMenuItem item = new JMenuItem(getString("Action." + actionName, mnemonic));
                item.setMnemonic(mnemonic);
                pmenu.add(copyActionTo(actionName, item));
                m.put(actionName, item);
            }
        }
        pmenu.addPopupMenuListener(new PopupMenuListener() {

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                m.get("undo").setEnabled(um.canUndo());
                m.get("redo").setEnabled(um.canRedo());
                final boolean textSelected = text.getSelectionEnd() > text.getSelectionStart();
                m.get("cut-to-clipboard").setEnabled(textSelected);
                m.get("copy-to-clipboard").setEnabled(textSelected);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                // empty
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                // empty
            }

        });
        text.setComponentPopupMenu(pmenu);
    }

    /**
     * eLXgR|[lg̃ANVݒ肷B
     * @param text eLXgR|[lg
     */
    static void setActionForTextComponent(JTextComponent text) {
        new ActionUtility(text).setActionForTextComponent();
    }

}
